<section class="it-contact it-section-pt it-section-pb">
    <div class="container">
        <div class="it-section-header">
            <div class="row justify-content-center">
                <div class="col-xl-6 col-lg-8 text-center">
                    <span class="it-section-caption"><i
                            class="bi bi-lightning-charge-fill"></i>{{ cms('contact', 'top_title') }}</span>
                    <h2 class="it-section-title">{{ cms('contact', 'title') }}</h2>
                    <p class="mb-0">{{ cms('contact', 'details') }}</p>
                </div>
            </div>
        </div>

        <div class="row gy-4 align-items-center">
            <div class="col-lg-6">
                <div class="it-message-contact-content">
                    <h4 class="title">{{ cms('contact', 'heading') }}</h4>

                    <div class="row mt-4">
                        <div class="col-lg-10">
                            <div class="row gy-4">
                                <div class="col-lg-12">
                                    <div class="it-message-contact-item">
                                        <div class="icon">
                                            <iconify-icon icon="icon-park-twotone:phone-call"></iconify-icon>
                                        </div>
                                        <div class="content">
                                            <p class="caption mb-0">{{ tt_front('Call Us') }}</p>
                                            <a href="tel:{{ cms('contact', 'phone') }}" class="details">
                                                <span>{{ cms('contact', 'phone') }}</span>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-12">
                                    <div class="it-message-contact-item">
                                        <div class="icon">
                                            <iconify-icon icon="ic:twotone-email"></iconify-icon>
                                        </div>
                                        <div class="content">
                                            <p class="caption mb-0">{{ tt_front('Email Us') }}</p>
                                            <a href="mailto:{{ cms('contact', 'email') }}" class="details">
                                                <span>{{ cms('contact', 'email') }}</span>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-12">
                                    <div class="it-message-contact-item">
                                        <div class="icon">
                                            <iconify-icon icon="iconamoon:location-pin-duotone"></iconify-icon>
                                        </div>
                                        <div class="content">
                                            <p class="caption mb-0">{{ tt_front('Visit Us') }}</p>
                                            <p class="details mb-0">
                                                <span>{{ cms('contact', 'address') }}</span>
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="it-message-contact-form">
                    <div class="text-lg-start text-center">
                        <h6>{{ tt_front('Send a Message') }}</h6>
                    </div>
                    <form class="mt-4" method="post" action="{{ route('contact') }}">
                        @csrf
                        <div class="row gy-3">
                            <div class="col-md-6">
                                <div class="form-floating">
                                    <input type="text" name="name" class="form-control"
                                        placeholder="{{ tt_front('Name') }}" required autocomplete="off">
                                    <label>{{ tt_front('Name') }}</label>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-floating">
                                    <input type="email" name="email" class="form-control"
                                        placeholder="{{ tt_front('Email') }}" autocomplete="off" required>
                                    <label>{{ tt_front('Email') }}</label>
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <div class="form-floating">
                                    <input type="text" name="subject" required class="form-control"
                                        placeholder="{{ tt_front('Subject') }}" autocomplete="off">
                                    <label>{{ tt_front('Subject') }}</label>
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <div class="form-floating">
                                    <textarea name="message" class="form-control" cols="6" rows="8"
                                        placeholder="{{ tt_front('Enter Message') }}"></textarea>
                                    <label>{{ tt_front('Message') }}</label>
                                </div>
                            </div>
                            <div class="col-12 mt-4">
                                <button type="submit" class="btn btn-primary w-100">{{ tt_front('Send Now') }} <i
                                        class="bi bi-arrow-up-right"></i></button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <div class="it-section-pt-sm">
            <div class="it-contact-map">
                <iframe src="{{ cms('contact', 'map_link') }}" allowfullscreen="" loading="lazy"
                    referrerpolicy="no-referrer-when-downgrade"></iframe>
            </div>
        </div>
    </div>

    <img src="{{ getFile('constant_image', 'shape-left.png') }}" alt="image" class="it-contact-left-el">
    <img src="{{ getFile('constant_image', 'shape-right.png') }}" alt="image" class="it-contact-right-el">
</section>
