<section class="it-faq it-section-pt it-section-pb">
    <div class="container">
        <div class="it-section-header">
            <div class="row gy-3 align-items-end">
                <div class="col-lg-6 text-lg-start text-center">
                    <span class="it-section-caption"><i
                            class="bi bi-lightning-charge-fill"></i>{{ cms('faq', 'top_title') }}</span>
                    <h2 class="it-section-title mb-0">{{ cms('faq', 'title') }}</h2>
                </div>
                <div class="col-lg-6 text-lg-start text-center">
                    <div class="pb-2">
                        <p>{{ cms('faq', 'details') }}</p>
                        <a href="{{ cms('faq', 'button_link', trans: false) }}"
                            class="btn btn-primary-gradient rounded-pill">{{ cms('faq', 'button_name') }}<i
                                class="bi bi-arrow-up-right"></i></a>
                    </div>
                </div>
            </div>
        </div>

        <div class="it-faq-slider">
            @foreach (cms('faq', '', cons()::ELEMENT) as $element)
                <div class="single-slide">
                    <div class="it-faq-single">
                        <h5>{{ tt_front($element->content->title) }}</h5>
                        <p class="mb-0">{{ tt_front($element->content->details) }}</p>
                    </div>
                </div>
            @endforeach
        </div>
        <div class="it-faq-slider-nav">
            <button type="button" class="it-faq-slider-nav-prev"><i class="bi bi-arrow-left"></i></button>
            <button type="button" class="it-faq-slider-nav-next"><i class="bi bi-arrow-right"></i></button>
        </div>
    </div>

    <img src="{{ getFile('constant_image', 'shape-left.png') }}" alt="image" class="it-faq-left-shape">
    <img src="{{ getFile('constant_image', 'shape-right.png') }}" alt="image" class="it-faq-right-shape">
</section>

@once('slick_css')
    @push('style')
        <link rel="stylesheet" href="{{ css('slick.css', cons()::ASSETS_FROM_FRONTEND) }}">
    @endpush
@endonce

@push('script')
    @once('slick_js')
        <script src="{{ js('slick.min.js', cons()::ASSETS_FROM_FRONTEND) }}"></script>
        <script src="{{ js('slick-animation.min.js', cons()::ASSETS_FROM_FRONTEND) }}"></script>
    @endonce

    <script>
        $(function() {
            'use strict'
            $('.it-faq-slider').slick({
                dots: false,
                infinite: true,
                speed: 300,
                slidesToShow: 2,
                slidesToScroll: 1,
                arrows: true,
                prevArrow: $(".it-faq-slider-nav-prev"),
                nextArrow: $(".it-faq-slider-nav-next"),
                autoplay: false,
                speed: 500,
                autoplaySpeed: 1500,
                cssEase: 'linear',
                responsive: [{
                        breakpoint: 1400,
                        settings: {
                            slidesToShow: 3,
                            arrows: true
                        }
                    },
                    {
                        breakpoint: 1200,
                        settings: {
                            slidesToShow: 2,
                            arrows: true
                        }
                    },
                    {
                        breakpoint: 992,
                        settings: {
                            slidesToShow: 2,
                            arrows: true
                        }
                    },
                    {
                        breakpoint: 767,
                        settings: {
                            slidesToShow: 1,
                            arrows: true
                        }
                    }
                ]
            });
        });
    </script>
@endpush
