<section class="it-how-work it-section-pt it-section-pb">
    <div class="container">
        <div class="it-section-header">
            <div class="row gy-3 align-items-center justify-content-between">
                <div class="col-xl-8 text-xl-start text-center">
                    <span class="it-section-caption"><i
                            class="bi bi-lightning-charge-fill"></i>{{ cms('how_work', 'top_title') }}</span>
                    <h2 class="it-section-title mb-0">{{ cms('how_work', 'title') }}</h2>
                </div>
                <div class="col-xxl-2 col-xl-3 text-xl-end text-center">
                    <a href="{{ cms('how_work', 'button_link', trans: false) }}"
                        class="btn btn-primary-gradient">{{ cms('how_work', 'button_name') }}<i
                            class="bi bi-arrow-up-right"></i></a>
                </div>
            </div>
        </div>

        <div class="row gy-4">
            @foreach (cms('how_work', '', cons()::ELEMENT) as $element)
                <div class="col-xl-3 col-sm-6">
                    <div class="it-how-work-item">
                        <div class="it-how-work-item-icon">
                            <?= $element->content->icon ?>
                        </div>
                        <div class="it-how-work-item-content">
                            <span class="it-how-work-item-step text-sm">0{{ $loop->iteration }}</span>
                            <h5 class="title">{{ tt_front($element->content->title) }}</h5>
                            <p class="mb-0">{{ tt_front($element->content->details) }}</p>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>

    <img src="{{ getFile('constant_image', 'bg-el-1.png') }}" alt="image" class="it-how-work-bg-el">
</section>
