<section class="it-team it-section-pt it-section-pb">
    <div class="container">
        <div class="row">
            <div class="col-lg-4 text-lg-start text-center">
                <span class="it-section-caption"><i
                        class="bi bi-lightning-charge-fill"></i>{{ cms('team', 'top_title') }}</span>
                <h2 class="it-section-title mb-3">{{ cms('team', 'title') }}</h2>
                <p class="mb-0">{{ cms('team', 'short_description') }}</p>
                <div class="it-team-slider-nav">
                    <button type="button" class="it-team-slider-nav-left"><i class="bi bi-arrow-left"></i></button>
                    <button type="button" class="it-team-slider-nav-right"><i class="bi bi-arrow-right"></i></button>
                </div>
            </div>
            <div class="col-lg-8 ps-xl-5">
                <div class="it-team-slider">
                    @foreach (cms('team', '', cons()::ELEMENT) as $element)
                        <div class="single-slide">
                            <div class="it-team-single">
                                <div class="it-team-single-thumb">
                                    <img src="{{ getFile('cms', $element->content->image) }}" alt="image">
                                    <div class="name">
                                        <H4>{{ $element->content->name }}</H4>
                                    </div>
                                </div>
                                <div class="it-team-single-content">
                                    <p class="mb-2 text-primary">{{ $element->content->position }}</p>
                                    <ul class="social-links">
                                        <li><a href="{{ $element->content->facebook_link }}" target="_blank"><i
                                                    class="fa-brands fa-facebook-f"></i></a>
                                        </li>
                                        <li><a href="{{ $element->content->twitter_link }}" target="_blank"><i
                                                    class="fa-brands fa-x-twitter"></i></a>
                                        </li>
                                        <li><a href="{{ $element->content->linkedin_link }}" target="_blank"><i
                                                    class="fa-brands fa-linkedin-in"></i></a></li>
                                        <li><a href="{{ $element->content->instagram_link }}" target="_blank"><i
                                                    class="fa-brands fa-instagram"></i></a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>

        <img src="{{ getFile('constant_image', 'bg-shape-3.png') }}" alt="image" class="it-team-bg-el">
        <img src="{{ getFile('constant_image', '3d-el-1.png') }}" alt="image" class="it-team-el-1">
    </div>
</section>

@once('slick_css')
    @push('style')
        <link rel="stylesheet" href="{{ css('slick.css', cons()::ASSETS_FROM_FRONTEND) }}">
    @endpush
@endonce

@push('script')
    @once('slick_js')
        <script src="{{ js('slick.min.js', cons()::ASSETS_FROM_FRONTEND) }}"></script>
        <script src="{{ js('slick-animation.min.js', cons()::ASSETS_FROM_FRONTEND) }}"></script>
    @endonce

    <script>
        'use strict'

        $(function() {
            $('.it-team-slider').slick({
                dots: false,
                infinite: true,
                speed: 300,
                slidesToShow: 3,
                slidesToScroll: 1,
                arrows: true,
                prevArrow: $(".it-team-slider-nav-left"),
                nextArrow: $(".it-team-slider-nav-right"),
                autoplay: true,
                speed: 500,
                autoplaySpeed: 1500,
                cssEase: 'linear',
                responsive: [{
                        breakpoint: 1400,
                        settings: {
                            slidesToShow: 3,
                        }
                    },
                    {
                        breakpoint: 1200,
                        settings: {
                            slidesToShow: 3
                        }
                    },
                    {
                        breakpoint: 992,
                        settings: {
                            slidesToShow: 2
                        }
                    },
                    {
                        breakpoint: 576,
                        settings: {
                            slidesToShow: 1,
                        }
                    }
                ]
            });
        });
    </script>
@endpush
