<section class="it-testimonial it-section-pt it-section-pb">
    <div class="container">
        <div class="it-section-header">
            <div class="row justify-content-center">
                <div class="col-lg-7 text-center">
                    <span class="it-section-caption"><i
                            class="bi bi-lightning-charge-fill"></i>{{ cms('testimonial', 'top_title') }}</span>
                    <h2 class="it-section-title mb-0">{{ cms('testimonial', 'title') }}</h2>
                </div>
            </div>
        </div>

        <div class="it-testimonial-slider">
            @foreach (cms('testimonial', '', cons()::ELEMENT) as $element)
                <div class="single-slide">
                    <div class="it-testimonial-single">
                        <img src="{{ getFile('cms', $element->content->company_log) }}" alt="image"
                            class="it-testimonial-logo">
                        <h5 class="title">{{ tt_front($element->content->title) }}</h5>
                        <p>{{ tt_front($element->content->review_details) }}</p>
                        <div class="text-sm mb-4 text-white">
                            @for ($i = 0; $i < $element->content->rating; $i++)
                                <i class="fa-solid fa-star"></i>
                            @endfor
                        </div>
                        <div class="it-testimonial-client">
                            <div class="thumb">
                                <img src="{{ getFile('cms', $element->content->client_image) }}" alt="image">
                            </div>
                            <div class="content">
                                <h6 class="name text-md mb-1">{{ $element->content->name }}</h6>
                                <p class="mb-0 text-sm text-primary">{{ tt_front($element->content->designation) }}</p>
                            </div>
                        </div>
                        <span class="it-testimonial-icon">
                            <iconify-icon icon="oi:double-quote-sans-left"></iconify-icon>
                        </span>
                    </div>
                </div>
            @endforeach
        </div>
    </div>

    <img src="{{ getFile('constant_image', 'middle-shade-two.png') }}" alt="image" class="it-testimonial-top-el">
    <img src="{{ getFile('constant_image', 'left-star.png') }}" alt="image" class="it-testimonial-left-el">
    <img src="{{ getFile('constant_image', 'right-star.png') }}" alt="image" class="it-testimonial-right-el">
</section>

@once('slick_css')
    @push('style')
        <link rel="stylesheet" href="{{ css('slick.css', cons()::ASSETS_FROM_FRONTEND) }}">
    @endpush
@endonce

@push('script')

    @once('slick_js')
        <script src="{{ js('slick.min.js', cons()::ASSETS_FROM_FRONTEND) }}"></script>
        <script src="{{ js('slick-animation.min.js', cons()::ASSETS_FROM_FRONTEND) }}"></script>
    @endonce

    <script>
        $(function() {
            'use strict'
            $('.it-testimonial-slider').slick({
                dots: true,
                infinite: true,
                speed: 300,
                slidesToShow: 3,
                slidesToScroll: 1,
                arrows: false,
                autoplay: true,
                speed: 500,
                autoplaySpeed: 1500,
                cssEase: 'linear',
                responsive: [{
                        breakpoint: 1400,
                        settings: {
                            slidesToShow: 3,
                        }
                    },
                    {
                        breakpoint: 1200,
                        settings: {
                            slidesToShow: 2
                        }
                    },
                    {
                        breakpoint: 992,
                        settings: {
                            slidesToShow: 2
                        }
                    },
                    {
                        breakpoint: 767,
                        settings: {
                            slidesToShow: 1,
                        }
                    }
                ]
            });


        });
    </script>
@endpush
