@extends('frontend::layouts.user_master')
@section('content')
    <div class="container-fluid">
        <div class="row justify-content-center">
            <div class="col-xxl-8">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title mb-0 text-center">{{ tt_front('Choose currency and calculate ') }}
                            {{ tt_front('token price') }}</h4>
                    </div>
                    <div class="card-body py-4">
                        <div class="buy-stage-wrapper">
                            <div class="buy-stage-wrapper-left">
                                <ul class="nav nav-tabs bordered-tab" id="myTab" role="tablist">
                                    <li class="nav-item" role="presentation">
                                        <button
                                            class="nav-link {{ $setting->currency->currency_type == cons()::CRYPTO ? 'active' : '' }}"
                                            id="crypto-tab" data-bs-toggle="tab" data-bs-target="#crypto-tab-pane"
                                            type="button" role="tab" aria-controls="crypto-tab-pane"
                                            aria-selected="true">{{ tt_front('Crypto Currency') }}</button>
                                    </li>
                                    <li class="nav-item" role="presentation">
                                        <button
                                            class="nav-link {{ $setting->currency->currency_type == cons()::FIAT ? 'active' : '' }}"
                                            id="fiat-tab" data-bs-toggle="tab" data-bs-target="#fiat-tab-pane"
                                            type="button" role="tab" aria-controls="fiat-tab-pane"
                                            aria-selected="false">{{ tt_front('Fiat Currency') }}</button>
                                    </li>
                                </ul>
                                <div class="tab-content" id="myTabContent">
                                    <div class="tab-pane fade {{ $setting->currency->currency_type == cons()::CRYPTO ? 'show active' : '' }}"
                                        id="crypto-tab-pane" role="tabpanel" aria-labelledby="crypto-tab" tabindex="0">
                                        <div class="stage-currency-wrapper scroll-y">
                                            @foreach ($crypto as $k => $item)
                                                <div class="form-check stage-currency-single"
                                                    data-currency="{{ $item->id }}">
                                                    <input class="form-check-input"
                                                        {{ $item->id == $setting->currency_id ? 'checked' : '' }}
                                                        type="radio" name="crypto" id="crypto-{{ $k }}">
                                                    <label class="form-check-label" for="crypto-{{ $k }}">
                                                        <img src="{{ getFile('currency', $item->icon) }}" alt="image">
                                                        <p class="flex-grow-0 mb-0 ps-3">
                                                            <span
                                                                class="d-block fw-semibold lh-1 text-white">{{ $item->name }}</span>
                                                            <span class="text-sm">{{ $stage->exchangeRate($item) }}
                                                                {{ $item->name }}</span>
                                                        </p>
                                                    </label>
                                                </div>
                                            @endforeach
                                        </div>
                                    </div>
                                    <div class="tab-pane fade {{ $setting->currency->currency_type == cons()::FIAT ? 'show active' : '' }}"
                                        id="fiat-tab-pane" role="tabpanel" aria-labelledby="fiat-tab" tabindex="0">
                                        <div class="stage-currency-wrapper scroll-y">
                                            @foreach ($fiat as $k => $item)
                                                <div class="form-check stage-currency-single"
                                                    data-currency="{{ $item->id }}">
                                                    <input class="form-check-input"
                                                        {{ $item->id == $setting->currency_id ? 'checked' : '' }}
                                                        type="radio" name="crypto" id="fiat-{{ $k }}">
                                                    <label class="form-check-label" for="fiat-{{ $k }}">
                                                        <img src="{{ getFile('currency', $item->icon) }}" alt="image">
                                                        <p class="flex-grow-0 mb-0 ps-3">
                                                            <span
                                                                class="d-block fw-semibold lh-1 text-white">{{ $item->name }}</span>
                                                            <span class="text-sm">{{ $stage->exchangeRate($item) }}
                                                                {{ $item->name }}</span>
                                                        </p>
                                                    </label>
                                                </div>
                                            @endforeach
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="buy-stage-wrapper-right">
                                <div>
                                    <label class="form-label">{{ tt_front('Get Token') }}</label>
                                    <div class="buy-token-field-wrapper">
                                        <span class="buy-token-field-wrapper-icon">
                                            <i class="bi bi-arrow-down"></i>
                                        </span>

                                        <div class="buy-token-field">
                                            <input type="number" name="get_token" class="form-control input-arrow-hidden"
                                                value="{{ $stage->soft_cap }}" autocomplete="off">
                                            <span class="buy-token-field-icon">
                                                <img src="{{ getFile('ico_icon', $setting->icon) }}" alt="image">
                                                {{ $setting->token_symbol }}
                                            </span>
                                        </div>

                                        <div class="buy-token-field">
                                            <input type="number" name="payable_amount"
                                                class="form-control input-arrow-hidden"
                                                value="{{ $stage->exchangeRate($setting->currency) * $stage->soft_cap }}">
                                            <span class="buy-token-field-icon converter-field-icon">
                                                <img src="{{ getFile('currency', $setting->currency->icon) }}"
                                                    alt="image" class="rounded-circle">
                                                {{ $setting->currency->name }}
                                            </span>
                                        </div>
                                    </div>
                                    <p class="text-sm text-muted mt-2 mb-0"><i class="fa-solid fa-circle-info"></i>
                                        {{ tt_front('Minimum purchase token ') }} {{ $stage->soft_cap }}
                                        {{ tt_front('and maximum') }} {{ $stage->hard_cap }}</p>
                                </div>

                                <div class="d-flex flex-wrap gap-3 mt-4">
                                    @if($crypto->isNotEmpty() || $fiat->isNotEmpty())
                                    <button type="button"
                                        class="btn btn-md btn-primary-gradient flex-grow-1 buy-payment">{{ tt_front('Payment
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                Now') }}</button>
                                    @endif
                                    <button type="button" data-action="{{ route('stage.buy.balance', $stage->id) }}"
                                        class="btn btn-md btn-outline-light flex-grow-1 buy-balance">{{ tt_front('Pay with
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                Balance') }}</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade" id="usingBalanceModal" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <form method="post">
                    <div class="modal-header">
                        <h1 class="modal-title mb-0" id="userImageModalLabel">{{ tt_front('Buy With Balance') }}</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body text-center">
                        @csrf
                        <input type="hidden" name="hidden_currency_id" value="{{ $setting->currency_id }}">
                        <input type="hidden" name="hidden_quantity" value="{{ $stage->soft_cap }}">
                        <p class="mb-1">{{ tt_front('Are you sure to buy token ') }} ?</p>
                        <small>{{ tt_front('Only purchase using ') }} <span
                                class="text-primary">{{ tc()->get('currency') }}</span></small>
                    </div>
                    <div class="modal-footer justify-content-center">
                        <button type="submit" class="btn btn-md btn-primary rounded">{{ tt_front('Buy Now') }}</button>
                    </div>
                </form>
            </div>
        </div>
    </div>


    <div class="modal fade" id="usingPaymentModal" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <form method="post"
                    action="{{ route('stage.buy.payment', ['stage' => $stage->id, 'currency' => $setting->currency_id]) }}">
                    <div class="modal-header">
                        <h1 class="modal-title mb-0" id="userImageModalLabel">{{ tt_front('Payment Now') }}</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body text-center">
                        @csrf
                        <input type="hidden" name="hidden_quantity" value="{{ $stage->soft_cap }}">
                        <p class="my-3">{{ tt_front('Are you sure to buy token ') }} ?</p>
                    </div>
                    <div class="modal-footer justify-content-center">
                        <button type="submit" class="btn btn-md btn-primary rounded">{{ tt_front('Buy Now') }}</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection


@push('script')
    <script>
        $(function() {
            'use strict';

            let infos = {
                stage: "{{ $stage->id }}",
                currency: "{{ $setting->currency_id }}",
                get_token: $('input[name="get_token"]').val()
            }
            $('.stage-currency-single').on('change', function() {
                infos.currency = $(this).data('currency');
                calculation(infos)
            })

            $('input[name="get_token"]').on('input', function() {
                infos.get_token = $(this).val();
                calculation(infos);
            })


            function calculation(data) {
                $.ajax({
                    url: "{{ route('stage.buy.calculation') }}",
                    type: 'get',
                    data: data,
                    success: function(response) {
                        $('.converter-field-icon').html(response.html);
                        $("input[name='payable_amount']").val(response.payable_amount)
                        $("#usingBalanceModal").find('input[name="hidden_currency_id"]').val(data
                            .currency);
                        $("#usingBalanceModal").find('input[name="hidden_quantity"]').val(data
                            .get_token);

                        $('#usingPaymentModal').find('form').attr('action', response.payment_route);
                        $('#usingPaymentModal').find('input[name="hidden_quantity"]').val(data
                            .get_token);

                    }
                })
            }

            $('.buy-balance').on('click', function() {
                let action = $(this).data('action');
                let modal = $("#usingBalanceModal");
                modal.find('form').attr('action', action);
                modal.modal('show');
            });

            $(".buy-payment").on('click', function() {
                let modal = $("#usingPaymentModal");
                modal.modal('show');
            });

        });
    </script>
@endpush
