@extends('frontend::layouts.user_master')
@section('content')
    <div class="container-fluid">
        <div class="row gy-xl-4 gy-3">

            @forelse($stages as $stage)
                @if (stageStatus($stage->id)['status'])
                    <div class="col-xxl-4 col-md-6">
                        <div class="stage-card">
                            <span class="badge badge-light-success">{{ tt_front(stageStatus($stage->id)['message']) }}</span>
                            <h6 class="d-flex align-items-center justify-content-center gap-2">
                                <span class="text-primary"><i class="bi bi-lightning-charge-fill"></i></span>
                                {{ $stage->title }}
                            </h6>

                            <p class="text-center">1 {{ $setting->token_symbol }} = {{ formatter($stage->base_price) }}
                                {{ $setting->currency->name }}</p>

                            <div class="stage-card-time">
                                <div class="stage-card-time-single">
                                    <span class="text-muted text-sm">{{ tt_front('Start Date') }}</span>
                                    <p class="mb-0 text-sm">{{ dateFormatter($stage->start_date) }}</p>
                                </div>
                                <div class="stage-card-time-single">
                                    <span class="text-muted text-sm">{{ tt_front('End Date') }}</span>
                                    <p class="mb-0 text-sm">{{ dateFormatter($stage->end_date) }}</p>
                                </div>
                            </div>

                            <div class="mt-4">
                                <div class="d-flex flex-wrap align-items-center justify-content-between mt-4 text-sm">
                                    <p class="mb-2">{{ $stage->bonus_token }} {{ tt_front('Token Bonus') }}</p>
                                    <p class="mb-2">{{ $stage->purchaseToken() }} / {{ $stage->token_issues }}</p>
                                </div>

                                <div class="ico-box-progress-area">
                                    <span class="ico-box-progress-label"
                                        style="left: {{ $stage->tokenSellPercentage() }}%">{{ $stage->tokenSellPercentage() }}%</span>
                                    <div class="progress ico-box-progress" role="progressbar"
                                        aria-label="Example with label" aria-valuenow="{{ $stage->tokenSellPercentage() }}"
                                        aria-valuemin="0" aria-valuemax="100">
                                        <div class="progress-bar bg-primary rounded-pill"
                                            style="width: {{ $stage->tokenSellPercentage() }}%"></div>
                                    </div>
                                </div>
                            </div>

                            @if (!stageStatus($stage->id)['is_buy'])
                                <button disabled
                                    class="btn btn-md btn-primary-gradient w-100 mt-4">{{ tt_front('Buy Now') }}
                                    <i class="bi bi-arrow-up-right"></i></button>
                            @else
                                <a href="{{ route('stage.buy', $stage->id) }}"
                                    class="btn btn-md btn-primary-gradient w-100 mt-4">{{ tt_front('Buy Now') }}
                                    <i class="bi bi-arrow-up-right"></i></a>
                            @endif


                            <img src="{{ getFile('constant_image', 'bg-shape-3.png') }}" alt="image"
                                class="stage-card-img">
                        </div>
                    </div>
                @endif
            @empty
                <div class="col-lg-12">
                    <div class="no-data-wrapper">
                        <div class="w-100">
                            <div class="row justify-content-center">
                                <div class="col-lg-6 text-center">
                                    <img src="{{ getFile('constant_image', 'no-data-found.png') }}" alt="image"
                                        class="no-data-wrapper-img">
                                    <p class="mt-4 mb-0">{{ tt_front('No Stage found') }}</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            @endforelse
        </div>
    </div>
@endsection
