@extends('frontend::layouts.user_master')
@section('content')
    <div class="container-fluid">
        <div class="card">
            <div class="card-header d-flex flex-wrap align-items-center justify-content-between gap-2">
                <h4 class="card-title mb-0">{{ tt_front('Purchase Stages') }}</h4>

                <form class="d-flex flex-wrap gap-2">
                    <div>
                        <input type="text" name="trx" class="form-control form-control-md" autocomplete="off"
                            placeholder="{{ tt_front('Trx....') }}">

                    </div>
                    <select class="form-select form-select-md w-auto" name="status">
                        <option value="">{{ tt_front('Select Status') }}</option>
                        <option value="{{ cons()::ACCEPTED }}" @selected(request()->status == cons()::ACCEPTED)>{{ tt_front('Completed') }}
                        </option>
                        <option value="{{ cons()::PENDING }}" @selected(request()->status == cons()::PENDING)>{{ tt_front('Pending') }}
                        </option>
                        <option value="{{ cons()::REJECTED }}"> @selected(request()->status == cons()::REJECTED){{ tt_front('Rejected') }}
                        </option>
                    </select>
                    <button type="submit" class="btn btn-md btn-primary-gradient">{{ tt_front('Search') }}</button>
                </form>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table default-table head-light-bg responsive-table mb-0 radius-lg">
                        <thead>
                            <tr>
                                <th>{{ tt_front('Trx') }}</th>
                                <th>{{ tt_front('Token Quantity') }}</th>
                                <th>{{ tt_front('Bonus') }}</th>
                                <th>{{ tt_front('Total Price') }}</th>
                                <th>{{ tt_front('Status') }}</th>
                                <th>{{ tt_front('Note') }}</th>
                                <th>{{ tt_front('Date') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($purchases as $purchase)
                                <tr>
                                    <td>
                                        <p class="mb-0 text-muted">{{ $purchase->stage->title }}</p>
                                        <span class="fw-semibold">{{ $purchase->trx }}</span>
                                    </td>
                                    <td>{{ $purchase->token }} {{ $setting->token_symbol }}</td>
                                    <td>{{ $purchase->bonus_token }} {{ $setting->token_symbol }}</td>
                                    <td>{{ $purchase->totalPrice() }} </td>
                                    <td>
                                        <?= $purchase->status() ?>
                                    </td>
                                    <td>{{ $purchase->note }}</td>
                                    <td>
                                        {{ dateFormatter($purchase->created_at) }}
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="6" class="text-center">
                                        <div class="no-data-wrapper">
                                            <div class="w-100">
                                                <div class="row justify-content-center">
                                                    <div class="col-lg-6 text-center">
                                                        <img src="{{ getFile('constant_image', 'no-data-found.png') }}"
                                                            alt="image" class="no-data-wrapper-img">
                                                        <p class="mt-4 mb-0 text-md">{{ tt_front('No auction found') }}</p>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection
