@extends('installer.master')

@section('content')
    <form  method="post">
        @csrf
        <main class="tt-installer-body">
            <div class="container">
                <div class="tt-installer-card overlay">
                    <h2 class="tt-installer-card-title mb-40 text-center">{{ __('Set Admin Credentials') }}</h2>

                    <div class="row">
                        <div class="col-6 mb-16">
                            <label class="input-label">{{ __('Username') }}</label>
                            <input type="text" name="admin_username" class="input-field" value="{{old('admin_username')}}">
                            @error('admin_username')
                                <div class="text-danger text-sm">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="col-6 mb-16">
                            <label class="input-label">{{ __('Email') }}</label>
                            <input type="email" name="admin_email" class="input-field" value="{{old('admin_email')}}">
                            @error('admin_email')
                                <div class="text-danger text-sm">{{ $message }}</div>
                            @enderror

                        </div>
                        <div class="col-12">
                            <label class="input-label">{{ __('Password') }}</label>
                            <input type="text" name="admin_password" class="input-field">
                            @error('admin_password')
                                <div class="text-danger text-sm">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>
            </div>
        </main>

        <footer class="tt-installer-footer">
            <div class="container">
                <div class="tt-footer-wrapper">
                    <a href="{{ route('permissions') }}" class="tt-footer-btn">
                        <i class="ri-arrow-left-s-line"></i>
                        {{ __('Previous') }}
                    </a>
                    <button type="submit" class="tt-footer-btn btn-solid">
                        {{ __('Install Now') }}
                        <i class="ri-arrow-right-s-line"></i>
                    </button>
                </div>
            </div>
        </footer>
    </form>
@endsection
