@extends('installer.master')
@section('content')
    <form  method="post">
        @csrf
        <main class="tt-installer-body">
            <div class="container">
                <div class="tt-installer-card overlay">
                    <h2 class="tt-installer-card-title mb-40 text-center">{{ __('Database Setup') }}</h2>

                    <div class="row">

                        <div class="col-6 mb-16">
                            <label class="input-label">{{ __('Licence key') }}</label>
                            <input type="text" name="licence_key" class="input-field" value="{{old('licence_key')}}">
                            @error('licence_key')
                                <div class="text-danger text-sm">{{ $message }}</div>
                            @enderror
                        </div>
                        
                        <div class="col-6 mb-16">
                            <label class="input-label">{{ __('Codecanyon username') }}</label>
                            <input type="text" name="code_username" class="input-field" value="{{old('code_username')}}">
                            @error('code_username')
                                <div class="text-danger text-sm">{{ $message }}</div>
                            @enderror
                        </div>

                        
                        <div class="col-6 mb-16">
                            <label class="input-label">{{ __('App Name') }}</label>
                            <input type="text" name="app_name" class="input-field" value="{{old('app_name')}}">
                            @error('app_name')
                                <div class="text-danger text-sm">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-6 mb-16">
                            <label class="input-label">{{ __('Site Url') }}</label>
                            <input type="url" name="site_url" class="input-field" value="{{url('/');}}">
                            @error('site_url')
                                <div class="text-danger text-sm">{{ $message }}</div>
                            @enderror

                        </div>
                        <div class="col-6 mb-16">
                            <label class="input-label"> {{ __('Database name') }}</label>
                            <input type="text" name="database_name" class="input-field" value="{{old('database_name')}}">
                            @error('database_name')
                                <div class="text-danger text-sm">{{ $message }}</div>
                            @enderror

                        </div>
                        <div class="col-6 mb-16">
                            <label class="input-label"> {{ __('Database host') }}</label>
                            <input type="text" name="database_host" class="input-field" value="{{old('database_host')}}">
                            @error('database_host')
                                <div class="text-danger text-sm">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="col-6 mb-16">
                            <label class="input-label"> {{ __('Database User Name') }}</label>
                            <input type="text" name="database_username" class="input-field" value="{{old('database_username')}}">
                            @error('database_username')
                                <div class="text-danger text-sm">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="col-6 mb-16">
                            <label class="input-label"> {{ __('Database Password') }}</label>
                            <input type="text" name="database_password" class="input-field" value="{{old('database_password')}}">
                            @error('database_password')
                                <div class="text-danger text-sm">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="col-6 mb-16">
                            <label class="input-label"> {{ __('Database Port') }}</label>
                            <input type="number" name="database_port" min="1" max="65535" class="input-field" value="">
                            @error('database_port')
                                <div class="text-danger text-sm">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                </div>
            </div>
        </main>

        <footer class="tt-installer-footer">
            <div class="container">
                <div class="tt-footer-wrapper">
                    <a href="{{ route('permissions') }}" class="tt-footer-btn">
                        <i class="ri-arrow-left-s-line"></i>
                        {{ __('Previous') }}
                    </a>
                    <button type="submit" class="tt-footer-btn btn-solid">
                        {{ __('Next') }}
                        <i class="ri-arrow-right-s-line"></i>
                    </button>
                </div>
            </div>
        </footer>
    </form>
@endsection
