@extends('installer.master')
@section('content')
    <main class="tt-installer-body">
        <div class="container">
            <div class="tt-installer-card overlay">
                <h2 class="tt-installer-card-title mb-40 text-center">{{ __('Server Requirements') }}</h2>
                <ul class="requirement-list">
                    @if (version_compare(PHP_VERSION, '8.1', '>='))
                        <li class="accepted">
                            <i class="ri-checkbox-circle-fill"></i>
                            <span>{{ __('Required PHP version 8.1 or higher') }}</span>
                        </li>
                    @else
                        @php
                            $procceedtoNextPage = false;
                        @endphp
                        <li class="rejected">
                            <i class="ri-close-circle-fill"></i>
                            <span>{{ __('Required PHP version 8.1 or higher') }}</span>
                        </li>
                    @endif
                    @foreach ($config as $conf)
                        @if (checkExtenstion($conf))
                            <li class="accepted">
                                <i class="ri-checkbox-circle-fill"></i>
                                <span>{{ __('Required') }} {{ $conf }} {{ __('Extension') }}</span>
                            </li>
                        @else
                            @php
                                $procceedtoNextPage = false;
                            @endphp
                            <li class="rejected">
                                <i class="ri-close-circle-fill"></i>
                                <span>{{ __('Required') }} {{ $conf }} {{ __('Extension') }}</span>
                            </li>
                        @endif
                    @endforeach

                </ul>
            </div>
        </div>
    </main>

    <footer class="tt-installer-footer">
        <div class="container">
            <div class="tt-footer-wrapper">

                <a href="{{ route('installer') }}" class="tt-footer-btn">
                    <i class="ri-arrow-left-s-line"></i>
                    {{ __('Previous') }}
                </a>


                @if($procceedtoNextPage)

                <a href="{{ route('permissions') }}" class="tt-footer-btn btn-solid">
                    {{ __('Next') }}
                    <i class="ri-arrow-right-s-line"></i>
                </a>

                @else
                <button type="button" disabled class="tt-footer-btn btn-solid">
                    {{ __('Next') }}
                    <i class="ri-arrow-right-s-line"></i>
                </button>

                @endif
            </div>
        </div>
    </footer>
@endsection
