<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ __(' Installer') }}</title>
    <link rel="stylesheet" href=" {{ css('remixicon.css') }}">
    <link rel="stylesheet" href="{{ css('all.min.css') }}">
    <link rel="stylesheet" href="{{ css('bootstrap-icons.min.css') }}">
    <link rel="stylesheet" href="{{ css('jquery.toast.min.css') }}">
    <link rel="stylesheet" href=" {{ css('style.css', cons()::ASSETS_FROM_INSTALLER) }}">
</head>

<body>
    <div class="tt-installer-area">
        <header class="tt-installer-header">
            <div class="tt-installer-header-top">
                <div class="container text-center">
                    <h2 class="mb-4">{{ __('Effortlessly set up projects with  smart installation wizard') }}</h2>
                    <p class="mb-0 text-sm">{{ __('Power up your projects with  intelligent installation bot') }}</p>
                </div>
            </div>
            <div class="tt-installer-header-bottom">
                <div class="container">
                    <ul class="tt-installer-steps">
                        <li class="{{ request()->route()->getName() == 'installer' ? 'active' : '' }}">
                            <span class="icon">
                                <span class="icon-main"><i class="ri-rocket-line"></i></span>
                                <span class="icon-check"><i class="ri-checkbox-circle-fill"></i></span>
                            </span>
                            <span class="caption">{{ __('Get Started') }}</span>
                        </li>
                        <li class="{{ request()->route()->getName() == 'extensions' ? 'active' : '' }}">
                            <span class="icon">
                                <span class="icon-main"><i class="ri-stack-line"></i></span>
                                <span class="icon-check"><i class="ri-checkbox-circle-fill"></i></span>
                            </span>
                            <span class="caption">{{ __('Extension') }}</span>
                        </li>
                        <li class="{{ request()->route()->getName() == 'permissions' ? 'active' : '' }}">
                            <span class="icon">
                                <span class="icon-main"><i class="ri-shield-check-line"></i></span>
                                <span class="icon-check"><i class="ri-checkbox-circle-fill"></i></span>
                            </span>
                            <span class="caption">{{ __('Permission') }}</span>
                        </li>
                        <li class="{{ request()->route()->getName() == 'database' ? 'active' : '' }}">
                            <span class="icon">
                                <span class="icon-main"><i class="ri-database-2-line"></i></span>
                                <span class="icon-check"><i class="ri-checkbox-circle-fill"></i></span>
                            </span>
                            <span class="caption">{{ __('Database') }}</span>
                        </li>

                        <li class="{{ request()->route()->getName() == 'credentials' ? 'active' : '' }}">
                            <span class="icon">
                                <span class="icon-main"><i class="ri-database-2-line"></i></span>
                                <span class="icon-check"><i class="ri-checkbox-circle-fill"></i></span>
                            </span>
                            <span class="caption">{{ __('Credentials') }}</span>
                        </li>
                    </ul>
                </div>
            </div>
        </header>

        @yield('content')

    </div>
    <script src="{{ js('jquery-3.7.1.min.js') }}"></script>
    <script src="{{ js('jquery-ui.min.js') }}"></script>
    <script src="{{ js('jquery.toast.min.js') }}"></script>
    <script src="{{ js('bootstrap.bundle.min.js') }}"></script>

    @if (session()->has('error'))
        <script>
            'use strict'

            $.toast({
                text: "<i class='fa-solid fa-circle-exclamation'></i> {{ session('error') }}",
                showHideTransition: 'slide',
                bgColor: 'var(--warning)',
                textColor: '#fff',
                allowToastClose: true,
                hideAfter: 3000,
                stack: 5,
                textAlign: 'left',
                position: 'top-right'
            })
        </script>
    @endif


</body>

</html>
