@extends('installer.master')
@section('content')
    <main class="tt-installer-body">
        <div class="container">
            <div class="tt-installer-card overlay">
                <h2 class="tt-installer-card-title mb-40 text-center">{{ __('File Permission') }}</h2>
                <ul class="requirement-list">
                    @foreach ($permissions as $permission)
                        @if (folderPermissionCheck($permission))
                            <li class="accepted">
                                <i class="ri-checkbox-circle-fill"></i>
                                <span>{{ $permission }} {{ __('Required Permission: 0755') }}</span>
                            </li>
                        @else
                            @php
                                $procceedtoNextPage = false;
                            @endphp
                            <li class="rejected">
                                <i class="ri-checkbox-circle-fill"></i>
                                <span>{{ $permission }} {{ __('Required Permission: 0755') }}</span>
                            </li>
                        @endif
                    @endforeach
                </ul>
            </div>
        </div>
    </main>


    <footer class="tt-installer-footer">
        <div class="container">
            <div class="tt-footer-wrapper">

                <a href="{{ route('extensions') }}" class="tt-footer-btn">
                    <i class="ri-arrow-left-s-line"></i>
                    {{ __('Previous') }}
                </a>

                @if ($procceedtoNextPage)
                    <a href="{{ route('database') }}" class="tt-footer-btn btn-solid">
                        {{ __('Next') }}
                        <i class="ri-arrow-right-s-line"></i>
                    </a>
                @else
                    <button type="button" disabled class="tt-footer-btn btn-solid">
                        {{ __('Next') }}
                        <i class="ri-arrow-right-s-line"></i>
                    </button>
                @endif
            </div>
        </div>
    </footer>
@endsection
