@extends('frontend::layouts.user_master')

@section('content')
    <div class="user-dashbaord-body">

        <div class="container">

            <div class="row justify-content-center">
                @if (!user()->ability->twofa_enabled)
                    <div class="col-xl-8">
                        <div class="card">
                            <div class="card-header d-flex flex-wrap align-items-center justify-content-between gap-3">
                                <h4 class="card-title mb-0">{{ tt_front('Enable google authenticator') }}</h4>
                            </div>
                            <div class="card-body">
                                <p>{{ tt_front('Set up your two factor authentication by scanning the barcode below. Alternatively, you can use the code') }}
                                    <strong>{{ $secret }}</strong>
                                </p>

                                <div>
                                    <img src="data:image/png;base64,{{ $qrimage }}" alt="Qr Code">
                                </div>

                                <p>{{ tt_front('You must set up your Google Authenticator app before continuing. You will be unable to login otherwise') }}
                                </p>
                                <form class="form-horizontal" method="POST" action="{{ route('enable-2fa') }}">
                                    @csrf
                                    <div class="form-group">
                                        <label for="secret"
                                            class="form-label">{{ tt_front('Authenticator code') }}</label>
                                        <input id="secret" type="password" class="form-control col-md-12 mb-3"
                                            autocomplete="off" name="password" required>
                                    </div>
                                    <button type="submit" class="btn btn-primary rounded w-100">
                                        {{ tt_front('Enable 2fa') }}
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div>
                @else
                    <div class="col-xl-8">
                        <div class="card">
                            <div class="card-header d-flex flex-wrap align-items-center justify-content-between gap-3">
                                <h4 class="card-title mb-0">{{ tt_front('Disable google authenticator') }}</h4>
                            </div>

                            <div class="card-body">
                                <p>{{ tt_front('If you are looking to disable Two Factor Authentication. Please confirm your password and Click Disable 2FA Button') }}.

                                <form method="POST" action="{{ route('disable-two-factor-authentication') }}">
                                    @csrf
                                    <div class="">
                                        <label for="change-password"
                                            class="form-label">{{ tt_front('User Current Password') }}</label>
                                        <input id="current-password" type="password" class="form-control col-md-12 mb-4"
                                            name="password" required autocomplete="off">

                                    </div>
                                    <button type="submit"
                                        class="btn btn-primary rounded w-100">{{ tt_front('Disable 2FA') }}</button>
                                </form>

                            </div>
                        </div>


                    </div>
                @endif
            </div>


        </div>
    </div>
@endsection
