@extends('frontend::layouts.user_master')

@section('content')
    @php
        $deposit = App\Models\Deposit::where('trx', session('transaction')['trx'])->first();
        $gateway = App\Models\Gateway::find(session('transaction')['method_id']);
    @endphp

    <div class="container-fluid">
        <div class="row justify-content-center my-5">
            <div class="col-lg-10">
                <div class="card">
                    <div class="card-header">
                        <div class="send-money-steps @if ($gateway->gateway_type == cons()::OFFLINE_GATEWAY) steps-five @else step-four @endif">


                            <div class="send-money-single-step active">
                                <span class="send-money-single-step-amount">1</span>
                                <span class="send-money-single-step-caption">{{ tt_front('Deposit Method') }}</span>
                            </div>

                            @if ($gateway->gateway_type == cons()::OFFLINE_GATEWAY)
                                <div class="send-money-single-step active">
                                    <span class="send-money-single-step-amount">2</span>
                                    <span class="send-money-single-step-caption">{{ tt_front('Review & Confirm') }}</span>
                                </div>

                                <div class="send-money-single-step active">
                                    <span class="send-money-single-step-amount">3</span>
                                    <span class="send-money-single-step-caption">{{ tt_front('Verification') }}</span>
                                </div>

                                <div class="send-money-single-step active">
                                    <span class="send-money-single-step-amount">4</span>
                                    <span class="send-money-single-step-caption">{{ tt_front('Complete Deposit') }}</span>
                                </div>
                            @else
                                <div class="send-money-single-step active">
                                    <span class="send-money-single-step-amount">2</span>
                                    <span class="send-money-single-step-caption">{{ tt_front('Review & Confirm') }}</span>
                                </div>
                                <div class="send-money-single-step active">
                                    <span class="send-money-single-step-amount">3</span>
                                    <span class="send-money-single-step-caption">{{ tt_front('Complete Deposit') }}</span>
                                </div>
                            @endif



                        </div>
                    </div>
                    <div class="card-body py-sm-4">
                        <div class="row justify-content-center">
                            <div class="col-lg-8">
                                <div class="text-center">
                                    <h3>{{ tt_front('Deposit Final') }}</h3>
                                    <p>{{ tt_front('Please wait untill admin accept you deposit request') }}.</p>
                                </div>

                                <div class="border mt-4 p-3 rounded-2 d-inline-block extra-light-bg">
                                    <div class="row gy-2">
                                        <div class="col-md-6">
                                            <div class="p-2">
                                                <span class="text-sm text-muted">{{ tt_front('Recipient Name') }}</span>
                                                <p class="mb-0 fw-semibold">
                                                    {{ App\Models\User::find(session('transaction')['user_id'])->full_name }}
                                                </p>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="p-2">
                                                <span class="text-sm text-muted">{{ tt_front('TRX ID') }}</span>
                                                <p class="mb-0 fw-semibold">{{ session('transaction')['trx'] }}</p>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="p-2">
                                                <span class="text-sm text-muted">{{ tt_front('Deposit Amount') }}</span>
                                                <p class="mb-0 fw-semibold">
                                                    {{ session('transaction')['amount'] . ' ' . App\Models\Gateway::find(session('transaction')['method_id'])->currency }}
                                                </p>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="p-2">
                                                <span class="text-sm text-muted">{{ tt_front('Transaction Fee') }}</span>
                                                <p class="mb-0 fw-semibold">
                                                    {{ number_format(session('transaction')['charge'], 8) . ' ' . App\Models\Gateway::find(session('transaction')['method_id'])->currency }}
                                                </p>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="p-2">
                                                <span class="text-sm text-muted">{{ tt_front('Deposit Method') }}</span>
                                                <p class="mb-0 fw-semibold">
                                                    {{ App\Models\Gateway::find(session('transaction')['method_id'])->name }}
                                                </p>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="p-2">
                                                <span class="text-sm text-muted">{{ tt_front('Total Amount') }}</span>
                                                <p class="mb-0 fw-semibold text-success">
                                                    {{ session('transaction')['total_amount'] . ' ' . App\Models\Gateway::find(session('transaction')['method_id'])->currency }}
                                                </p>
                                            </div>
                                        </div>

                                        <div class="col-md-6">
                                            <div class="p-2">
                                                <span class="text-sm text-muted">{{ tt_front('Conversion Rate') }}</span>
                                                <p class="mb-0 fw-semibold">
                                                    1 {{ tc()->get('currency') }} =
                                                    {{ session('transaction')['rate'] . ' ' . App\Models\Gateway::find(session('transaction')['method_id'])->currency }}
                                                </p>
                                            </div>
                                        </div>


                                        <div class="col-md-6">
                                            <div class="p-2">
                                                <span
                                                    class="text-sm text-muted">{{ tt_front('Total Amount in Gateway Currency') }}</span>
                                                <p class="mb-0 fw-semibold">
                                                    {{ session('transaction')['amount_in_gateway_currency'] . ' ' . App\Models\Gateway::find(session('transaction')['method_id'])->currency }}
                                                </p>
                                            </div>
                                        </div>

                                        <div class="col-md-6">
                                            <div class="p-2">
                                                <span class="text-sm text-muted">{{ tt_front('Status') }}</span>
                                                @if ($deposit->status == cons()::PENDING)
                                                    <p class="mb-0 fw-semibold text-warning">
                                                        {{ tt_front('Pending') }}
                                                    </p>
                                                @else
                                                    <p class="mb-0 fw-semibold text-success">
                                                        {{ tt_front('Completed') }}
                                                    </p>
                                                @endif
                                            </div>
                                        </div>


                                    </div>
                                </div>

                                <div
                                    class="d-flex flex-wrap align-items-center justify-content-center align-items-center gap-3 mt-4">

                                    <a href="{{ route('deposit-log') }}"
                                        class="btn btn-md btn-primary-gradient">{{ tt_front('Back to Deposit Log') }}
                                        <i class="ri-arrow-right-line"></i></a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
