@extends('frontend::layouts.user_master')

@section('content')
    @php
        $gateway = App\Models\Gateway::find(session('transaction')['method_id']);
    @endphp
    <div class="container-fluid">
        <div class="row justify-content-center my-5">
            <div class="col-lg-8">
                <div class="card">
                    <div class="card-header">
                        <div class="send-money-steps @if ($gateway->gateway_type == cons()::OFFLINE_GATEWAY) steps-five @else step-four @endif">

                            <div class="send-money-single-step active">
                                <span class="send-money-single-step-amount">1</span>
                                <span class="send-money-single-step-caption">{{ tt_front('Deposit Method') }}</span>
                            </div>

                            @if ($gateway->gateway_type == cons()::OFFLINE_GATEWAY)
                                <div class="send-money-single-step">
                                    <span class="send-money-single-step-amount">2</span>
                                    <span class="send-money-single-step-caption">{{ tt_front('Review & Confirm') }}</span>
                                </div>

                                <div class="send-money-single-step">
                                    <span class="send-money-single-step-amount">3</span>
                                    <span class="send-money-single-step-caption">{{ tt_front('Verification') }}</span>
                                </div>

                                <div class="send-money-single-step">
                                    <span class="send-money-single-step-amount">4</span>
                                    <span class="send-money-single-step-caption">{{ tt_front('Complete Deposit') }}</span>
                                </div>
                            @else
                                <div class="send-money-single-step">
                                    <span class="send-money-single-step-amount">2</span>
                                    <span class="send-money-single-step-caption">{{ tt_front('Review & Confirm') }}</span>
                                </div>
                                <div class="send-money-single-step">
                                    <span class="send-money-single-step-amount">3</span>
                                    <span class="send-money-single-step-caption">{{ tt_front('Complete Deposit') }}</span>
                                </div>
                            @endif
                        </div>
                    </div>
                    <div class="card-body py-sm-4">
                        <div class="row justify-content-center">
                            <div class="col-lg-8">
                                <div class="text-center">
                                    <h3>{{ tt_front('Deposit Overview') }}</h3>
                                    <p>{{ tt_front('Fast and reliable international money transfer app.') }}</p>
                                </div>

                                <div class="border mt-4 p-3 rounded-2 d-inline-block extra-light-bg">
                                    <div class="row gy-2">

                                        <div class="col-md-6">
                                            <div class="p-2">
                                                <span class="text-sm text-muted">{{ tt_front('Deposit Method') }}</span>
                                                <p class="mb-0 fw-semibold">
                                                    {{ $gateway->name }}</p>
                                            </div>
                                        </div>

                                        <div class="col-md-6">
                                            <div class="p-2">
                                                <span class="text-sm text-muted">{{ tt_front('Deposit Amount') }}</span>
                                                <p class="mb-0 fw-semibold">
                                                    {{ session('transaction')['amount'] . ' ' . tc()->get('currency') }}
                                                </p>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="p-2">
                                                <span class="text-sm text-muted">{{ tt_front('Transaction Fee') }}</span>
                                                <p class="mb-0 fw-semibold">
                                                    {{ symbol(number_format(session('transaction')['charge'], 8), tc()->get('currency'), $gateway->currency_type) }}
                                                </p>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="p-2">
                                                <span
                                                    class="text-sm text-muted">{{ tt_front('Total Payable Amount') }}</span>
                                                <p class="mb-0 fw-semibold text-success">
                                                    {{ number_format(session('transaction')['amount_in_gateway_currency'], 8) . ' ' . $gateway->currency }}
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div
                                    class="d-flex flex-wrap align-items-center justify-content-between align-items-center gap-2 mt-4">
                                    <a href="{{ route('deposit') }}" class="btn btn-md btn-outline-light shadow-none"><i
                                            class="ri-arrow-left-line"></i>
                                        {{ tt_front('Back') }}</a>

                                    @if ($gateway->gateway_type == cons()::OFFLINE_GATEWAY)
                                        <a href="{{ route('deposit-requirements') }}"
                                            class="btn btn-md btn-primary-gradient">{{ tt_front('next') }}<i
                                                class="ri-arrow-right-line"></i></a>
                                    @else
                                        <form method="post">
                                            @csrf

                                            <button type="submit"
                                                class="btn btn-md btn-primary-gradient">{{ tt_front('Confirmation') }}
                                                <i class="ri-arrow-right-line"></i></button>
                                        </form>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
