@extends('frontend::layouts.user_master')

@section('content')
    <div class="user-dashbaord-body">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-6">
                    <div class="two-step-wrapper">
                        <div class="icon">
                            <span class="icon-inner">
                                <iconify-icon icon="streamline:qr-code-solid"></iconify-icon>
                            </span>
                        </div>
                        <h3 class="mt-4 text-center mb-1">{{ tt_front('Deposit via') }} {{ $cryptoPayment->method->name }}
                        </h3>
                        <p class="mt-4 alert alert-warning text-center mb-3 text-sm">
                            {{ tt_front('After completed deposit please click complete deposit button otherwise your deposit amount not added to your balance') }}
                        </p>
                        <h5 class="fw-bolder">{{ tt_front('Please send') }}
                            {{ $cryptoPayment->amount_received . ' ' . $cryptoPayment->currency }}</h5>
                        <span class="badge badge-light-warning">
                            <i class="ri-loader-line"></i>
                            <span id="timer">
                            </span>
                        </span>



                        <div class="qrcode-part mt-4">
                            <div class="qrcode-part-inner">
                                <img src="data:image/png;base64,{{ $cryptoPayment->qrcode }}" alt="image">
                            </div>
                        </div>

                        <a data-href="{{ route('crypto-payment-status', $cryptoPayment->id) }}"
                            class="btn btn-primary rounded-2 w-100 mt-sm-5 mt-4 complete">{{ tt_front('Complete Payment') }}</a>

                        <div class="or-divider w-100 mt-4">
                            <span>{{ tt_front('OR enter the code manually') }}</span>
                        </div>

                        <div class="mt-4 d-flex align-items-center gap-3 w-100">
                            <input type="text" name="#0"
                                class="py-2 px-3 w-100 flex-grow-1 border rounded-3 bg-light-light text-center fw-medium url-field"
                                value="{{ $cryptoPayment->pay_address }}">
                            <button type="button" class="py-2 px-3 border rounded-3 bg-light-light copy-btn"><i
                                    class="ri-file-copy-line"></i></button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('script')
    <script>
        $(function() {
            'use strict'

            function getParameterByName(name, url = window.location.href) {
                name = name.replace(/[\[\]]/g, '\\$&');
                const regex = new RegExp('[?&]' + name + '(=([^&#]*)|&|#|$)');
                const results = regex.exec(url);
                if (!results) return null;
                if (!results[2]) return '';
                return decodeURIComponent(results[2].replace(/\+/g, ' '));
            }

            const expiryTimestamp = getParameterByName('expires');

            if (expiryTimestamp) {
                const expiryTime = parseInt(expiryTimestamp) * 1000;

                function updateTimer() {
                    const now = new Date().getTime();
                    const timeLeft = expiryTime - now;

                    if (timeLeft > 0) {
                        const minutes = Math.floor((timeLeft % (1000 * 60 * 60)) / (1000 * 60));
                        const seconds = Math.floor((timeLeft % (1000 * 60)) / 1000);
                        $('#timer').text(`Payment expires in ${minutes}m ${seconds}s`);
                    } else {
                        $('#timer').text('Payment expired');
                        clearInterval(timerInterval);
                        window.location.href = "{{ route('dashboard') }}";
                    }
                }
                const timerInterval = setInterval(updateTimer, 1000);
            } else {
                $('#timer').text('Expiration time not found');
            }

            $('.complete').on('click', function(e) {
                e.preventDefault();
                $.ajax({
                    method: "POST",
                    url: $(this).data('href'),
                    data: {
                        _token: "{{ csrf_token() }}"
                    },
                    success: function(response) {

                        if (!response.status) {
                            $.toast({
                                text: "<i class='fa-solid fa-circle-exclamation'></i>" +
                                    response
                                    .message,
                                showHideTransition: 'slide',
                                bgColor: 'var(--warning)',
                                textColor: '#fff',
                                allowToastClose: true,
                                hideAfter: 3000,
                                stack: 5,
                                textAlign: 'left',
                                position: 'top-right'
                            })
                        } else {
                            $.toast({
                                text: "<i class='fa-solid fa-circle-exclamation'></i>" +
                                    response
                                    .message,
                                showHideTransition: 'slide',
                                bgColor: 'var(--success)',
                                textColor: '#fff',
                                allowToastClose: true,
                                hideAfter: 3000,
                                stack: 5,
                                textAlign: 'left',
                                position: 'top-right'
                            })


                            if (response.type == 'deposit') {
                                window.location.href = "{{ route('deposit-final') }}"
                            } else {
                                window.location.href = "{{ route('payment-final') }}"
                            }
                        }

                    }

                })
            })
        });
    </script>
@endpush
