<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>{{ tt_front('Flutterwave Payment') }}</title>
    <link rel="icon" type="image/png" href="{{ getFile('logo', tc()->get('icon')) }}">

    <script src="{{ js('jquery-3.7.1.min.js') }}"></script>
    <script src="https://checkout.flutterwave.com/v3.js"></script>
    <link rel="stylesheet" href="{{ css('bootstrap.min.css') }}">
    <link rel="stylesheet" href="{{ css('style.css', cons()::ASSETS_FROM_FRONTEND) }}">
</head>

<body>

    <div class="paymenty-loading-wrapper">
        <div class="paymenty-loading-container">
            <h5>{{ tt_front('Please wait. Your payment is processing') }}....</h5>
            <div class="spinner-border my-4" role="status">
                <span class="visually-hidden">{{ tt_front('Loading') }}...</span>
            </div>
            <p class="text-sm">
                {{ tt_front('Do not press browser back or forward button while you are in payment page') }}</p>
        </div>
    </div>
    @php
        $payable_amount = $data['amount_in_gateway_currency'];
        $payable_amount = round($payable_amount, 2);

    @endphp

    <script>
        'use strict'
        flutterwavePayment();

        function flutterwavePayment() {
            FlutterwaveCheckout({
                public_key: "{{ $method->parameters->public_key }}",
                tx_ref: "{{ $data['trx'] }}",
                amount: {{ $payable_amount }},
                currency: "{{ $method->currency }}",
                payment_options: "card, banktransfer, ussd",

                customer: {
                    email: "{{ $user->email }}",
                    phone_number: "{{ $user->phone }}",
                    name: "{{ $user->name }}",
                },
                callback: function(data) {
                    var tnx_id = data.transaction_id;
                    var _token = "{{ csrf_token() }}";
                    var method = "{{ $method->id }}";
                    $.ajax({
                        type: 'post',
                        data: {
                            tnx_id: tnx_id,
                            _token: _token,
                            method: "{{ $method->name }}",
                        },
                        url: "{{ url('payment-check', $method->name) }}",
                        success: function(response) {

                            if (response.status == 'success') {
                                window.location.href =
                                    "{{ route('payment-callback', $method->name) }}";
                            } else {
                                window.location.href =
                                    "{{ route('payment-cancel', $method->name) }}";
                            }
                        },
                        error: function(err) {

                            window.location.href = "{{ route('payment-cancel', $method->name) }}";
                        }
                    });
                },
                onclose: function() {
                    window.location.href = "{{ route('payment-cancel', $method->name) }}";
                },
                customizations: {
                    title: "{{ $method->name }}",
                    logo: "{{ getFile($method->image, 'gateways') }}",
                },
            });
        }
    </script>
</body>

</html>
