<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>{{tt_front('Paystack Payment')}}</title>
    <link rel="icon" type="image/png" href="{{ getFile('logo', tc()->get('icon')) }}">

    <script src="{{ js('jquery-3.7.1.min.js') }}"></script>
    <script src="https://js.paystack.co/v1/inline.js"></script>
    <link rel="stylesheet" href="{{ css('bootstrap.min.css') }}">
    <link rel="stylesheet" href="{{ css('style.css', cons()::ASSETS_FROM_FRONTEND) }}">
</head>

<body>

    <div class="paymenty-loading-wrapper">
        <div class="paymenty-loading-container">
            <h5>{{tt_front('Please wait. Your payment is processing')}}....</h5>
            <div class="spinner-border my-4" role="status">
                <span class="visually-hidden">{{tt_front('Loading')}}...</span>
            </div>
            <p class="text-sm">{{tt_front('Do not press browser back or forward button while you are in payment page')}}</p>
        </div>
    </div>

@php
    $public_key = $method->parameters->public_key;
    $currency = $method->currency;
    $currency = strtoupper($currency);

    $ngn_amount = $data['amount'];
    $ngn_amount = $ngn_amount * 100;
    $ngn_amount = round($ngn_amount);
@endphp
<script>

'use strict';

    payWithPaystack()
    function payWithPaystack(){

        var handler = PaystackPop.setup({
            key: '{{ $public_key }}',
            email: '{{ $user->email }}',
            amount: '{{ $ngn_amount }}',
            currency: "{{ $currency }}",
            callback: function(response){
            let reference = response.reference;
            let tnx_id = response.transaction;
            let _token = "{{ csrf_token() }}";
            $.ajax({
                type: "get",
                data: {reference: reference, tnx_id: tnx_id, _token:_token, method:"{{$method->name}}"},
                url: "{{ route('payment-check', $method->name) }}",
                success: function(response) {
                    if(response.status){
                        window.location.href = "{{ route('payment-callback', $method->name) }}";
                    }else{
                        window.location.href = "{{ route('payment-cancel', $method->name) }}";
                    }
                },
                error: function(response){

                    window.location.href = "{{ route('payment-cancel', $method->name) }}";
                }
            });
            },
            onClose: function(){
                window.location.href = "{{ route('payment-cancel', $method->name) }}";
            }
        });
        handler.openIframe();

    }
</script>

</body>
</html>
