<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>{{ tt_front('Perfectmoney Payment') }}</title>
    <link rel="icon" type="image/png" href="{{ getFile('logo', tc()->get('icon')) }}">
    <link rel="stylesheet" href="{{ css('bootstrap.min.css') }}">
    <link rel="stylesheet" href="{{ css('style.css', cons()::ASSETS_FROM_FRONTEND) }}">
</head>

<body>

    <div class="paymenty-loading-wrapper">
        <div class="paymenty-loading-container">
            <h5>{{tt_front('Please wait. Your payment is processing')}}....</h5>
            <div class="spinner-border my-4" role="status">
                <span class="visually-hidden">{{tt_front('Loading')}}...</span>
            </div>
            <p class="text-sm">{{tt_front('Do not press browser back or forward button while you are in payment page')}}</p>
        </div>
    </div>


    <form action="https://perfectmoney.is/api/step1.asp" method="POST" id="form-submit">
        <input type="hidden" name="PAYEE_ACCOUNT" value="{{ $method->parameters->account_id }}">
        <input type="hidden" name="PAYEE_NAME" value="{{tc()->get('sitename') }}">
        <input type="hidden" name="PAYMENT_AMOUNT" value="{{ round($data['amount'], 2) }}" placeholder="Amount"
            class="form-control" readonly>
        <input type="hidden" name="PAYMENT_UNITS"
            value="{{ $method->currency }}">
        <input type="hidden" name="PAYMENT_URL" value="{{ route('payment-callback', $method->name) }}">
        <input type="hidden" name="NOPAYMENT_URL" value="{{ route('payment-cancel', $method->name) }}">

        <input type="hidden" name="PAYMENT_ID" value="{{ $data['trx'] }}">

        <input type="hidden" name="STATUS_URL" value="{{ route('payment-callback',$method->name) }}">

        <input type="hidden" name="PAYMENT_URL_METHOD" value="GET">

        <input type="hidden" name="NOPAYMENT_URL_METHOD" value="GET">

        <input type="hidden" name="SUGGESTED_MEMO" value="{{ user()->username }}">
    </form>

    <script src="{{ js('jquery-3.7.1.min.js') }}"></script>

    <script>
        $(function(){
            'use strict'
            $('#form-submit').submit()
        })
    </script>
</body>

</html>
