<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <link rel="stylesheet" href="{{ css('bootstrap.min.css') }}">
    <link rel="stylesheet" href="{{ css('style.css', cons()::ASSETS_FROM_FRONTEND) }}">
</head>

<body>

    <div class="paymenty-loading-wrapper">
        <div class="paymenty-loading-container">
            <h5>{{tt_front('Please wait. Your payment is processing')}}....</h5>
            <div class="spinner-border my-4" role="status">
                <span class="visually-hidden">{{tt_front('Loading')}}...</span>
            </div>
            <p class="text-sm">{{tt_front('Do not press browser back or forward button while you are in payment page')}}</p>
        </div>
    </div>
    <form method="POST" class="needs-validation" novalidate>

        <button class="btn btn-primary btn-lg btn-block" id="sslczPayBtn" token="if you have any token validation"
            postdata="your javascript arrays or objects which requires in backend"
            order="If you already have the transaction generated for current order"
            endpoint="{{ route('payment-check') }}"> {{tt_front('Pay Now')}}
        </button>
    </form>


    <script src="{{ js('jquery-3.7.1.min.js') }}"></script>

    <script>
        'use strict';
        var obj = {};
        obj.cus_name = "{{ user()->full_name }}";
        obj.cus_phone = "{{ user()->mobile }}";
        obj.cus_email = "{{ user()->email }}";
        obj.cus_addr1 = "{{ user()->address->address }}";
        obj.amount = {{ $data['amount_in_gateway_currency'] }};

        $('#sslczPayBtn').prop('postdata', obj);

        @if ($method->parameters->mode == 'sandbox')

            let url = "https://sandbox.sslcommerz.com/embed.min.js?" + Math.random().toString(36).substring(
                7);
        @else
            let url = "https://seamless-epay.sslcommerz.com/embed.min.js?" + Math.random().toString(36).substring(7);
        @endif


        (function(window, document) {
            var loader = function() {
                var script = document.createElement("script"),
                    tag = document.getElementsByTagName("script")[0];
                    script.src = url
                    tag.parentNode.insertBefore(script, tag);
            };

            window.addEventListener ? window.addEventListener("load", loader, false) : window.attachEvent("onload",
                loader);
        })(window, document);
    </script>
</body>

</html>
