@extends('frontend::layouts.user_master')

@section('content')
    <div class="user-dashbaord-body">
        <div class="container">
            <div class="rt-log-card">
                <div class="row">
                    <div class="col-lg-8 border-lg-end">
                        <div class="rt-log-card-list">
                            <h4 class="mb-1 h5">{{ tt_front('Deposit History') }}</h4>
                            <p class="mb-0 text-sm">{{ $total_deposits . ' Deposits' }}</p>

                            <form method="GET">
                                <div class="d-flex flex-wrap align-items-center gap-2 mt-3">
                                    <div class="flex-grow-1">
                                        <select class="form-select form-select-sm" name="sort">
                                            <option value="">{{ tt_front('Select Status') }}</option>
                                            <option value="pending">{{ tt_front('Pending') }}</option>
                                            <option value="accepted">{{ tt_front('Accepted') }}</option>
                                            <option value="rejected">{{ tt_front('Rejected') }}</option>
                                        </select>
                                    </div>

                                    <div class="d-flex flex-wrap align-items-center gap-2 flex-grow-1">
                                        <div class="position-relative flex-grow-1">
                                            <input type="date" name="from" class="form-control form-control-sm datepickerWithIcon"
                                                autocomplete="off"  value="{{request()->from}}">
                                        </div>
                                        <span>{{tt_front('to')}}</span>
                                        <div class="position-relative flex-grow-1">
                                            <input type="date" name="to" class="form-control form-control-sm datepickerWithIcon"
                                                autocomplete="off"  value="{{request()->to}}">
                                        </div>
                                    </div>

                                    <div class="position-relative flex-grow-1">
                                        <input type="text" name="trx" class="form-control form-control-sm ps-35"
                                            placeholder="TRX ID...">
                                        <span class="position-absolute top-middle start-10">
                                            <i class="ri-search-line"></i>
                                        </span>
                                    </div>

                                    <button type="submit" class="btn btn-sm btn-primary-gradient flex-grow-1">
                                        <i class="ri-filter-line"></i> {{ tt_front('Filter') }}
                                    </button>
                                </div>
                            </form>
                            @php
                                $isActiveSet = true;
                            @endphp

                            <div class="transaction-all mt-4 scroll-y">
                                @forelse ($deposits as $date => $deposit)
                                    <h6 class="text-md text-muted mb-2">{{ dateFormatter($date) }}</h6>

                                    @foreach ($deposit as $item)
                                        <div class="single-transaction {{ $isActiveSet ? 'active' : '' }}"
                                            data-deposit="{{ $item->id }}">
                                            <div class="d-flex align-items-center gap-sm-3 gap-2">
                                                <span
                                                    class="avatar-lg bg-light-success text-succ ess rounded-circle item-center text-xxl flex-shrink-0">
                                                    <i class="ri-wallet-line"></i>
                                                </span>
                                                <div>
                                                    <h6 class="mb-0 text-md text-muted fw-medium">
                                                        {{ tt_front('Deposit via') }} <span
                                                            class="fw-semibold display-color">{{ $item->method->name }}</span>
                                                    </h6>
                                                    <p class="mb-0 text-sm">{{ tt_front('TRX') }}: {{ $item->trx }}</p>
                                                </div>
                                            </div>
                                            <div>
                                               <h6 class="mb-0 text-md">{{ symbol($item->amount,tc()->get('currency'), $item->method->currency_type) }}</h6>
                                                <p class="text-sm mb-0">{{ symbol($item->charge,tc()->get('currency'), $item->method->currency_type) }}</p>
                                            </div>
                                        </div>

                                        @php
                                            $isActiveSet = false;
                                        @endphp
                                    @endforeach
                                @empty

                                    <tr>
                                        <td colspan="6" class="text-center">
                                            <div class="no-data-wrapper">
                                                <span class="icon">
                                                    <iconify-icon icon="hugeicons:property-search"></iconify-icon>
                                                </span>
                                                <p class="mb-0 mt-2">{{ tt_front("Don't have data") }}</p>
                                            </div>
                                        </td>
                                    </tr>
                                @endforelse

                            </div>

                            @if ($deposits->hasPages())
                                <div class="mt-4">
                                    {{ $deposits->links() }}
                                </div>
                            @endif
                        </div>
                    </div>
                    <div class="col-lg-4">
                        <div class="rt-log-card-details" id="log-details">

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('script')
    <script>
        $(function() {

            'use strict'

            function getLogDetails(id, type) {
                $.ajax({
                    method: "GET",
                    url: "{{ route('fetch-details') }}",
                    data: {
                        id: id,
                        type: type
                    },
                    success: function(response) {
                        $('#log-details').html(response)
                    }
                })
            }

            getLogDetails($('.single-transaction.active').data('deposit'), 'deposit')

            $('.single-transaction').on('click', function() {
                getLogDetails($(this).data('deposit'), 'deposit')

                $('.single-transaction').removeClass('active')

                $(this).addClass('active')

            })


        })
    </script>
@endpush
