<h4 class="mb-3 h5">{{ tt_front($title) }}</h4>

<div class="d-flex flex-wrap align-items-center gap-3">
    <span class="avatar-lg bg-light-success text-success rounded-circle item-center text-xxl flex-shrink-0">
        <iconify-icon icon="fluent:payment-16-regular"></iconify-icon>
    </span>
    <div>
        <p class="mb-0 text-sm">{{ tt_front('Amount') }}</p>
        <h6 class="mb-0 text-md">{{ symbol($details->amount) }}</h6>
    </div>
</div>

<div class="border rounded mt-4 extra-light-bg p-3 d-flex flex-column gap-3">
    <div class="d-flex flex-wrap align-items-center justify-content-between gap-2 text-sm">
        <span>{{ tt_front('Transaction ID') }}</span>
        <span class="fw-semibold">#{{ $details->trx }}</span>
    </div>
    <div class="d-flex flex-wrap align-items-center justify-content-between gap-2 text-sm">
        <span>{{ tt_front('Date') }}</span>
        <span class="fw-semibold">{{ dateFormatter($details->created_at) }}</span>
    </div>
    <div class="d-flex flex-wrap align-items-center justify-content-between gap-2 text-sm">
        <span>{{ tt_front('Charge') }}</span>
        <span class="fw-semibold">{{ symbol($details->charge) }}</span>
    </div>
    <div class="d-flex flex-wrap align-items-center justify-content-between gap-2 text-sm">
        <span>{{ tt_front('Status') }}</span>
        <?= status($details, '', 'deposit') ?>
    </div>
    <div class="d-flex flex-wrap align-items-center justify-content-between gap-2 text-sm">
        <span>{{ tt_front('Final Amount') }}</span>
        <span class="fw-semibold">{{ symbol($details->total_amount) }}</span>
    </div>

    @if ($details->status == cons()::REJECTED)
        <div class="d-flex flex-wrap align-items-center justify-content-between gap-2 text-sm">
            <span>{{ tt_front('Reason') }}</span>
            <span class="fw-semibold">{{ $details->reason }}</span>
        </div>
    @endif

</div>
