<h4 class="mb-3 h5">{{ tt_front($title) }}</h4>

<div class="d-flex flex-wrap align-items-center gap-3">
    <span class="avatar-lg bg-light-success text-success rounded-circle item-center text-xxl flex-shrink-0">
        <iconify-icon icon="fluent:payment-16-regular"></iconify-icon>
    </span>
    <div>
        <p class="mb-0 text-sm">{{ tt_front('Amount') }}</p>
        <h6 class="mb-0 text-md">{{ number_format($details->amount,$details->formatter).' '.tc()->get('currency') }}</h6>
    </div>
</div>

<div class="border rounded mt-4 extra-light-bg p-3 d-flex flex-column gap-3">
    <div class="d-flex flex-wrap align-items-center justify-content-between gap-2 text-sm">
        <span>{{ tt_front('Transaction ID') }}</span>
        <span class="fw-semibold">#{{ $details->trx }}</span>
    </div>
    <div class="d-flex flex-wrap align-items-center justify-content-between gap-2 text-sm">
        <span>{{ tt_front('Date') }}</span>
        <span class="fw-semibold">{{ dateFormatter($details->created_at) }}</span>
    </div>

    <div class="d-flex flex-wrap align-items-center justify-content-between gap-2 text-sm">
        <span>{{ tt_front('Type') }}</span>
        <span class="fw-semibold">
            @if ($details->type == '+')
                <span class="text-success">
                    <i class="ri-add-circle-line"></i>
                    {{ tt_front('Credited', cons()::LANGUAGE_BACKEND) }}
                </span>
            @else
                <span class="text-danger">
                    <i class="ri-indeterminate-circle-line"></i>
                    {{ tt_front('Debited', cons()::LANGUAGE_BACKEND) }}
                </span>
            @endif
        </span>
    </div>

    <div class="d-flex flex-wrap align-items-center justify-content-between gap-2 text-sm">
        <span>{{ tt_front('Reason') }}</span>
        <span class="fw-semibold">{{ $details->reason }}</span>
    </div>


</div>
