@extends('frontend::layouts.user_master')

@section('content')
    <div class="user-dashbaord-body">
        <div class="container">
            <div class="row gy-4">
                <div class="col-xxl-12">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title mb-0">{{ tt_front('Notifications') }}</h4>
                        </div>
                        <div class="card-body p-0">
                            <div class="table-responsive">
                                <table class="table default-table head-light-bg responsive-table mb-0">
                                    <thead>
                                        <tr>
                                            <th>{{ tt_front('Notification') }}</th>
                                            <th>{{ tt_front('Date') }}</th>
                                            <th>{{ tt_front('Action') }}</th>
                                        </tr>
                                    </thead>
                                    <tbody>

                                        @forelse ($notifications as $notification)
                                            <tr class="remove">
                                                <td>
                                                    <div class="d-flex flex-wrap align-items-center gap-2">
                                                        <span
                                                            class="avatar-lg bg-light-warning text-warning rounded-circle item-center text-xxl flex-shrink-0">
                                                            <i class="ri-arrow-right-up-line"></i>
                                                        </span>
                                                        <div>
                                                            <h6 class="mb-0 text-sm">{{ $notification->data['message'] }}
                                                            </h6>

                                                        </div>
                                                    </div>
                                                </td>

                                                <td>
                                                    {{ dateFormatter($notification->created_at) }}
                                                </td>

                                                <td>

                                                    <div class="form-check style-check">
                                                        <input class="form-check-input mark"
                                                            data-action="{{ route('notification-read', $notification->id) }}"
                                                            type="checkbox" value="">
                                                    </div>

                                                </td>
                                            </tr>
                                        @empty


                                            <tr>
                                                <td colspan="6" class="text-center">
                                                    <div class="no-data-wrapper">
                                                        <span class="icon">
                                                            <iconify-icon icon="hugeicons:property-search"></iconify-icon>
                                                        </span>
                                                        <p class="mb-0 mt-2">{{ tt_front("Don't have data") }}</p>
                                                    </div>
                                                </td>
                                            </tr>
                                        @endforelse
                                    </tbody>



                                </table>
                            </div>
                        </div>
                        @if($notifications->hasPages())

                            <div class="card-footer">
                                {{$notifications->links() }}
                            </div>

                        @endif
                    </div>
                </div>

            </div>
        </div>
    </div>
@endsection

@push('script')
    <script>
        $(function() {
            'use strict';
            $('.mark').on('click', function() {
                $.ajax({
                    method: "GET",
                    url: $(this).data('action'),
                    success: function(response) {
                        if (response.status) {
                            $.toast({
                                text: response.message,
                                showHideTransition: 'slide',
                                bgColor: 'var(--success)',
                                textColor: '#fff',
                                allowToastClose: true,
                                hideAfter: 5000,
                                stack: 5,
                                textAlign: 'left',
                                position: 'top-right'
                            })
                        }


                    }
                })

                $(this).closest(".remove").remove()
            })
        })
    </script>
@endpush
