@if ($gateway->currency_type == cons()::FIAT)
    <div class="border mt-3 mb-3 p-3 rounded-2 extra-light-bg">
        <h6 class="text-sm mb-3">{{ tt_front('Deposit Account Information') }}:</h6>
        <div class="row">
            <div class="col-lg-6">
                <ul class="text-xs d-flex flex-column gap-2">
                    @foreach ($gateway->parameters->sending_options as $option)
                        <li class="d-flex align-items-center">
                            <span class="w-50 text-muted">{{ tt_front($option->title) }}</span>
                            <span class="w-50 display-color fw-medium">{{ tt_front($option->value) }}</span>
                        </li>
                    @endforeach
                </ul>
            </div>
        </div>
    </div>
@else
    @if (isset($gateway->parameters->qr_code))
        <div class="border mt-3 mb-3 p-3 rounded-2 extra-light-bg">
            <h6 class="text-sm mb-3">{{ tt_front('Qr Code') }}:</h6>
            <div class="row">
                <div class="col-lg-6">
                    <ul class="text-xs d-flex flex-column gap-2">
                        <li class="d-flex align-items-center">
                            <span class="w-50 display-color fw-medium">
                                <img src="{{ getFile('gateways', $gateway->parameters->qr_code) }}" alt="">
                            </span>
                        </li>

                    </ul>
                </div>
            </div>
        </div>
    @endif
@endif

<div class="border mt-3 mb-3 p-3 rounded-2 extra-light-bg">
    <h6 class="text-sm mb-3">{{ tt_trans('Payment instruction') }}:</h6>
    <div class="text-sm">
        <p class="mb-0">
            <?= $gateway->parameters->details ?>
        </p>
    </div>
</div>


@if ($gateway->parameters->proof)
    @foreach ($gateway->parameters->proof as $proof)
        <div class="mb-3 mt-3">
            <label class="form-label">{{ tt_front($proof->label_name) }}</label>
            @if ($proof->field_type == 'text')
                <input type="text" name="proof[{{ $proof->field_name }}]" class="form-control">
            @elseif($proof->field_type == 'textarea')
                <textarea name="proof[{{ $proof->field_name }}]" cols="30" rows="5" class="form-control"></textarea>
            @else
                <input type="file" name="proof[{{ $proof->field_name }}]" class="form-control">
            @endif
        </div>
    @endforeach
@endif
