@extends('frontend::layouts.user_master')
@section('content')
    <div class="container-fluid">
        <div class="row justify-content-center">
            <div class="col-lg-8">
                <div class="card">
                    <div class="card-header">
                        <div class="send-money-steps steps-three">
                            <div class="send-money-single-step active">
                                <span class="send-money-single-step-amount">1</span>
                                <span class="send-money-single-step-caption">{{ tt_front('Amount') }}</span>
                            </div>
                            <div class="send-money-single-step">
                                <span class="send-money-single-step-amount">2</span>
                                <span class="send-money-single-step-caption">{{ tt_front('Overview') }}</span>
                            </div>
                            <div class="send-money-single-step">
                                <span class="send-money-single-step-amount">3</span>
                                <span class="send-money-single-step-caption">{{ tt_front('Payment') }}</span>
                            </div>
                        </div>
                    </div>
                    <div class="card-body py-sm-4">
                        <div class="text-center">
                            <h4>{{ tt_front('Payment Money') }}</h4>
                            <p>{{ tt_front('Fast and reliable international money transfer app.') }}</p>
                        </div>

                        <form method="post" action="{{route('payment')}}" enctype="multipart/form-data">
                            @csrf
                            <div class="mb-3">
                                <label class="form-label">{{ tt_front('Payment method') }}</label>
                                <div class="row g-3">
                                    @foreach ($methods as $item)
                                        @php
                                            $method = $item->gateway;
                                        @endphp
                                        <div class="col-lg-4 col-md-6">
                                            <div class="recipient-single">
                                                <img src="{{ getFile('gateways', $method->image) }}" alt="image"
                                                    class="recipient-single-thumb">
                                                <div class="recipient-single-content">
                                                    <h6 class="text-md mb-1">{{ $method->name }} <span
                                                            class="text-sm">({{ $method->currency }})</span> </h6>
                                                </div>
                                                <div class="form-check">
                                                    <input class="form-check-input selectGateway"
                                                        data-currency="{{ $method->currency }}" type="radio"
                                                        name="gateway_id" value="{{ $method->id }}"
                                                        id="recipient-{{ $method->id }}"
                                                        data-type="{{ $method->gateway_type == cons()::ONLINE_GATEWAY ? 'online' : 'offline' }}"
                                                        @checked($loop->first)>
                                                    <label class="form-check-label"
                                                        for="recipient-{{ $method->id }}"></label>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            </div>

                            <div class="mb-3 mt-4">
                                <label class="form-label">{{ tt_front('Payment amount') }} ( {{ $currency->name }} )</label>
                                <input type="number" step="any" name="amount" value="{{ $data['price'] }}"
                                    class="form-control" readonly placeholder="{{ tt_front('Enter payment Amount') }}" required>

                            </div>
                            <div
                                class="d-flex flex-wrap align-items-center justify-content-between align-items-center gap-2 mt-4">
                                <a href="{{ route('stage.buy',$data['stage_id']) }}" class="btn btn-md btn-outline-light shadow-none"><i
                                        class="ri-arrow-left-line"></i> {{ tt_front('Back') }}</a>
                                <button type="submit" class="btn btn-md btn-primary-gradient">{{ tt_front('Next Step') }}
                                    <i class="ri-arrow-right-line"></i></button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
