@extends('frontend::layouts.user_master')

@section('content')
    <div class="user-dashbaord-body">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-10">
                    <div class="card">
                        <div class="card-header">
                            <div
                                class="send-money-steps @if ($gateway->gateway_type == cons()::OFFLINE_GATEWAY) steps-five @else step-four @endif">
                                <div class="send-money-single-step active">
                                    <span class="send-money-single-step-amount">1</span>
                                    <span class="send-money-single-step-caption">{{ tt_front('Wallet Selection') }}</span>
                                </div>

                                <div class="send-money-single-step active">
                                    <span class="send-money-single-step-amount">2</span>
                                    <span class="send-money-single-step-caption">{{ tt_front('Payment Method') }}</span>
                                </div>

                                @if ($gateway->gateway_type == cons()::OFFLINE_GATEWAY)
                                    <div class="send-money-single-step active">
                                        <span class="send-money-single-step-amount">3</span>
                                        <span
                                            class="send-money-single-step-caption">{{ tt_front('Review & Confirm') }}</span>
                                    </div>

                                    <div class="send-money-single-step">
                                        <span class="send-money-single-step-amount">4</span>
                                        <span class="send-money-single-step-caption">{{ tt_front('Verification') }}</span>
                                    </div>

                                    <div class="send-money-single-step">
                                        <span class="send-money-single-step-amount">5</span>
                                        <span
                                            class="send-money-single-step-caption">{{ tt_front('Complete Payment') }}</span>
                                    </div>
                                @else
                                    <div class="send-money-single-step">
                                        <span class="send-money-single-step-amount">3</span>
                                        <span
                                            class="send-money-single-step-caption">{{ tt_front('Review & Confirm') }}</span>
                                    </div>
                                    <div class="send-money-single-step">
                                        <span class="send-money-single-step-amount">4</span>
                                        <span
                                            class="send-money-single-step-caption">{{ tt_front('Complete Payment') }}</span>
                                    </div>
                                @endif



                            </div>
                        </div>
                        <div class="card-body py-sm-4">
                            <div class="text-center">
                                <h3>{{ tt_front('Payment Money') }}</h3>
                                <p>{{ tt_front('Fast and reliable international money transfer app') }}.</p>
                            </div>

                            <form method="POST" enctype="multipart/form-data" action="{{ route('payment-overview') }}">
                                @csrf

                                <div id="instruction">

                                </div>

                                <div
                                    class="d-flex flex-wrap align-items-center justify-content-between align-items-center gap-2 mt-4">

                                    <a href="{{ route('payment-overview') }}"
                                        class="btn btn-md btn-outline-light shadow-none"><i class="ri-arrow-left-line"></i>
                                        {{ tt_front('Back') }}</a>

                                    <form method="post" enctype="multipart/form-data"
                                        action="{{ route('payment-overview') }}">

                                        <div id="instruction">

                                        </div>
                                        @csrf
                                        <button type="submit"
                                            class="btn btn-md btn-primary-gradient">{{ tt_front('Confirmation') }}
                                            <i class="ri-arrow-right-line"></i></button>
                                    </form>


                                </div>
                            </form>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('script')
    <script>
        $(function() {
            'use strict'

            function fetchOfflinePaymentDetails(id) {
                $.ajax({
                    method: "GET",
                    url: "{{ route('payment-instruction') }}",
                    data: {
                        method: id
                    },
                    success: function(response) {
                        $('#instruction').html(response)
                    }
                })
            }


            fetchOfflinePaymentDetails("{{ $gateway->id }}");

        })
    </script>
@endpush
