@extends('frontend::layouts.user_master')

@section('content')
    <div class="container">
        <div class="card">
            <div class="card-body">
                <div class="d-flex justify-content-between mb-3 align-items-center">
                    <h4 class="mb-0 text-lg">{{ tt_front('My Profile') }}</h4>
                    <button class="btn btn-sm btn-outline-secondary" data-bs-toggle="modal"
                    data-bs-target="#changePassword">{{ tt_front('Change password') }}<i
                        class="ri-edit-2-line"></i></button>
                </div>

                <div class="p-4 border rounded-3">
                    <div class="d-flex flex-wrap align-items-center justify-content-between gap-3">
                        <div class="d-flex flex-wrap align-items-center gap-3">
                            <img src="{{ getFile('user', user()->image) }}" alt="image"
                                class="avatar-5xl object-fit-cover rounded-circle border border-3 border-white">
                            <div>
                                <h5 class="mb-1">{{ user()->username }}</h5>
                                <p class="text-sm mb-0">{{ user()->email }}</p>
                            </div>
                        </div>
                        <div>
                            <button type="button" class="btn btn-sm btn-outline-secondary" data-bs-toggle="modal"
                                data-bs-target="#userImageModal">{{ tt_front('Edit') }}<i
                                    class="ri-edit-2-line"></i></button>
                        </div>
                    </div>
                </div>

                <div class="p-4 rounded-3 mt-4 light-gradient-bg">
                    <div class="row gy-4">
                        <div class="col-lg-10">
                            <h6 class="mb-4">{{ tt_front('Personal Information') }}</h6>
                            <div class="row gy-4">
                                <div class="col-sm-6">
                                    <p class="mb-1 fw-medium text-muted text-sm">{{ tt_front('First name') }}</p>
                                    <p class="mb-0 fw-medium display-color">{{ user()->f_name }}</p>
                                </div>
                                <div class="col-sm-6">
                                    <p class="mb-1 fw-medium text-muted text-sm">{{ tt_front('Last name') }}</p>
                                    <p class="mb-0 fw-medium display-color">{{ user()->l_name }}</p>
                                </div>
                                <div class="col-sm-6">
                                    <p class="mb-1 fw-medium text-muted text-sm">{{ tt_front('Email address') }}</p>
                                    <p class="mb-0 fw-medium display-color">{{ user()->email }}</p>
                                </div>
                                <div class="col-sm-6">
                                    <p class="mb-1 fw-medium text-muted text-sm">{{ tt_front('Phone') }}</p>
                                    <p class="mb-0 fw-medium display-color">{{ user()->mobile }}</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-2 text-lg-end">
                            <button type="button" class="btn btn-sm btn-outline-secondary" data-bs-toggle="modal"
                                data-bs-target="#personalInfoModal">{{ tt_front('Edit') }} <i
                                    class="ri-edit-2-line"></i></button>
                        </div>
                    </div>
                </div>

                <div class="p-4 rounded-3 mt-4 light-gradient-bg">
                    <div class="row gy-4">
                        <div class="col-lg-10">
                            <h6 class="mb-4">{{ tt_front('Address') }}</h6>
                            <div class="row gy-4">
                                <div class="col-sm-6">
                                    <p class="mb-1 fw-medium text-muted text-sm">{{ tt_front('Country') }}</p>
                                    <p class="mb-0 fw-medium display-color">{{ user()->address?->country }}</p>
                                </div>
                                <div class="col-sm-6">
                                    <p class="mb-1 fw-medium text-muted text-sm">{{ tt_front('City') }}</p>
                                    <p class="mb-0 fw-medium display-color">{{ user()->address?->city }}</p>
                                </div>
                                <div class="col-sm-6">
                                    <p class="mb-1 fw-medium text-muted text-sm">{{ tt_front('State') }}</p>
                                    <p class="mb-0 fw-medium display-color">{{ user()->address?->state }}</p>
                                </div>
                                <div class="col-sm-6">
                                    <p class="mb-1 fw-medium text-muted text-sm">{{ tt_front('Zip Code') }}</p>
                                    <p class="mb-0 fw-medium display-color">{{ user()->address?->zip }}</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-2 text-lg-end">
                            <button type="button" class="btn btn-sm btn-outline-secondary" data-bs-toggle="modal"
                                data-bs-target="#addressModal">{{ tt_front('Edit') }}<i
                                    class="ri-edit-2-line"></i></button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <x-modal id="userImageModal" size="" title="Update User Image">
        <form method="POST" action="{{ route('profile-image-update') }}" enctype="multipart/form-data">
            @csrf
            <div class="mb-3">
                <label for="formFile" class="form-label">{{ tt_front('Select Image') }}</label>
                <input class="form-control" type="file" id="formFile" name="image">
            </div>
            <div class="text-end">
                <button type="submit" class="btn btn-md btn-primary rounded">{{ tt_front('Save Now') }}</button>
            </div>
        </form>
    </x-modal>

    <x-modal title="Update Personal Information" id="personalInfoModal">
        <form method="POST" action="{{route('profile-update')}}">
            @csrf
            <div class="row gy-4">
                <div class="col-lg-6">
                    <label class="form-label">{{tt_front('First name')}}</label>
                    <input type="text" name="f_name" class="form-control" placeholder="Enter First Name" value="{{user()->f_name}}">
                </div>
                <div class="col-lg-6">
                    <label class="form-label">{{tt_front('Last name')}}</label>
                    <input type="text" name="l_name" class="form-control" placeholder="Enter Last Name" value="{{user()->l_name}}">
                </div>
                <div class="col-lg-6">
                    <label class="form-label">{{tt_front('Email address')}}</label>
                    <input type="email" name="email" class="form-control" placeholder="Enter Email Address" value="{{user()->email}}">
                </div>
                <div class="col-lg-6">
                    <label class="form-label">{{tt_front('Phone Number')}}</label>
                    <input type="text" name="mobile" class="form-control" placeholder="Enter Phone Number" value="{{user()->mobile}}">
                </div>
            </div>
            <div class="text-end mt-4">
                <button type="submit" class="btn btn-md btn-primary rounded">{{tt_front('Update Now')}}</button>
            </div>
        </form>
    </x-modal>

    <x-modal id="addressModal" title="Update Address">
        <form action="{{route('profile-address')}}" method="POST">
            @csrf
            <div class="row gy-4">
                <div class="col-lg-6">
                    <label class="form-label">{{tt_front('Country')}}</label>
                    <input type="text" name="country" class="form-control" placeholder="Enter Country" value="{{user()->address?->country}}">
                </div>
                <div class="col-lg-6">
                    <label class="form-label">{{tt_front('City')}}</label>
                    <input type="text" name="city" class="form-control" placeholder="Enter City" value="{{user()->address?->city}}">
                </div>
                <div class="col-lg-6">
                    <label class="form-label">{{tt_front('State')}}</label>
                    <input type="text" name="state" class="form-control" placeholder="Enter State" value="{{user()->address?->state}}">
                </div>
                <div class="col-lg-6">
                    <label class="form-label">{{tt_front('Zip code')}}</label>
                    <input type="text" name="zip" class="form-control" placeholder="Enter Zip Code" value="{{user()->address?->zip}}">
                </div>

                <div class="col-lg-12">
                    <label class="form-label">{{tt_front('Address')}}</label>
                    <input type="text" name="address" class="form-control" placeholder="Enter adress" value="{{user()->address?->address}}">
                </div>
            </div>
            <div class="text-end mt-4">
                <button type="submit" class="btn btn-md btn-primary rounded">{{tt_front('Update Now')}}</button>
            </div>
        </form>
    </x-modal>

    <x-modal id="changePassword" title="Update Password">

        <form action="{{route('update-password')}}" method="POST">
            @csrf
            <div class="row gy-4">
                <div class="col-lg-12">
                    <label class="form-label">{{tt_front('Old password')}}</label>
                    <input type="password" name="old_password" class="form-control" placeholder="Enter Old password">
                </div>
                <div class="col-lg-12">
                    <label class="form-label">{{tt_front('Password')}}</label>
                    <input type="password" name="password" class="form-control" placeholder="Enter Password">
                </div>
                <div class="col-lg-12">
                    <label class="form-label">{{tt_front('Confirm password')}}</label>
                    <input type="password" name="password_confirmation" class="form-control" placeholder="Enter confirm password">
                </div>
            </div>
            <div class="text-end mt-4">
                <button type="submit" class="btn btn-md btn-primary rounded">{{tt_front('Update Now')}}</button>
            </div>
        </form>
    </x-modal>
@endsection
