@extends('frontend::layouts.user_master')

@section('content')
    <div class="user-dashbaord-body">
        <div class="container">
            <div class="card">
                <div class="card-header d-flex flex-wrap align-items-center justify-content-between gap-3">
                    <h4 class="card-title mb-0">{{ tt_front('Refer a friend', cons()::LANGUAGE_FRONTEND) }}</h4>

                    <div class="d-flex flex-wrap align-items-center gap-3">
                        <span class="display-color">{{ tt_front('Share Link', cons()::LANGUAGE_FRONTEND) }}:</span>
                        <div class="text-lg">
                            <div class="social-media-links">
                                <?= $shareComponent ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="d-flex flex-wrap align-items-center justify-content-between">
                        <div>
                            <h6>{{ tt_front('How is works') }}</h6>
                            <ul class="text-sm">
                                <li>
                                    <span class="text-success"><i class="ri-checkbox-circle-line"></i></span>
                                    {{ tt_front('Copy referral link or email invitations') }}.
                                </li>
                                <li>
                                    <span class="text-success"><i class="ri-checkbox-circle-line"></i></span>
                                    {{ tt_front('Share with your friends & others') }}.
                                </li>
                                <li>
                                    <span class="text-success"><i class="ri-checkbox-circle-line"></i></span>
                                    {{ tt_front('Make money on their deposit and payment') }}.
                                </li>
                            </ul>
                        </div>
                        <div class="rt-referral-icon pe-xl-5">
                            <iconify-icon icon="icon-park-outline:connect"></iconify-icon>
                        </div>
                    </div>
                    <hr>
                    <label class="form-label">{{ tt_front('Your referral link', cons()::LANGUAGE_FRONTEND) }}</label>
                    <div class="row g-3 align-items-center">
                        <div class="col-lg-9">
                            <input type="text" class="form-control url-field"
                                value="{{ request()->root() . '/registration/' . user()->username }}" readonly>
                        </div>
                        <div class="col-lg-3">
                            <button type="button" class="btn btn-primary-gradient display-color rounded copy-btn w-100"><i
                                    class="ri-file-copy-line"></i> {{ tt_front('Copy') }}</button>
                        </div>
                    </div>

                    <div class="or-divider my-4">
                        <span>{{ tt_front('or') }}</span>
                    </div>

                    <label class="form-label">{{ tt_front('Email Invites') }}</label>
                    <form action="{{ route('send-referral-link') }}" method="post">
                        @csrf
                        <div class="row g-3">
                            <div class="col-lg-9">
                                <select class="form-select-two form-select-two-tokenizer" multiple="multiple"
                                    name="emails[]">
                                </select>
                            </div>
                            <div class="col-lg-3">
                                <button type="submit"
                                    class="btn btn-primary-gradient display-color rounded w-100">{{ tt_front('Send Invites') }}
                                    <i class="ri-send-plane-2-line"></i></button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>


            <div class="card mt-4">
                <div class="card-header">
                    <h4 class="card-title mb-0">{{ tt_front('Referral Tree') }}</h4>
                </div>
                <div class="card-body">
                    <ul class="referral-tree">
                        @include('user::referral.tree', showReferralTree($user, user()->id))
                    </ul>
                </div>
            </div>

        </div>
    </div>
@endsection

@push('style')
    <link rel="stylesheet" href="{{ css('select2.min.css') }}">
@endpush
