@extends('frontend::layouts.user_master')

@section('content')
    <div class="user-dashbaord-body">
        <div class="container">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex flex-wrap align-items-center justify-content-between gap-3">
                        <h4 class="card-title mb-0">{{tt_front('Create A New Ticket')}}</h4>
                        <a href="{{route('support.index')}}" class="text-sm fw-semibold"><i class="ri-arrow-left-line"></i> {{tt_front('Back')}}</a>
                    </div>
                </div>
                <div class="card-body">
                    <form method="POST" action="{{route('support.store')}}" enctype="multipart/form-data">
                        @csrf
                        <div class="row gy-4">
                            <div class="col-lg-12">
                                <label class="form-label">{{tt_front('Ticket title')}}</label>
                                <input type="text" name="title" class="form-control" placeholder="Enter Ticket Title" value="{{old('title')}}">
                            </div>
                            <div class="col-lg-12">
                                <label class="form-label">{{tt_front('Message')}}</label>
                                <textarea name="message" cols="6" rows="6" class="form-control" placeholder="Enter Your Message">{{old('message')}}</textarea>
                            </div>
                        </div>

                        <div id="allFiles"></div>

                        <div class="d-flex flex-wrap align-items-center justify-content-end gap-2 mt-3">
                            <button type="button" id="addFiles" class="btn btn-md btn-outline-light shadow-none"><i
                                    class="ri-file-add-line"></i>
                                {{tt_front('Add Files')}}</button>
                            <button type="submit" class="btn btn-md btn-primary rounded"><i class="ri-reply-line"></i>
                                {{tt_front('Create Ticket')}}</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('script')
    <script>
        'use strict';
        $(document).ready(function() {

            $('#addFiles').on('click', function() {
                $('#allFiles').append(`
                <div class="mt-3 single-file d-flex align-items-end gap-2">
                    <div class="flex-grow-1">
                        <input class="form-control form-control-sm" type="file" name="files[]">
                    </div>
                    <button type="button" class="btn btn-sm btn-danger flex-shrink-0"><i class="ri-close-line"></i></button>
                </div>
            `);
            });

            // Function to remove a file
            $(document).on('click', '.btn-danger', function() {
                $(this).closest('.single-file').remove();
            });
        });
    </script>
@endpush
