@extends('frontend::layouts.user_master')

@section('content')
    <div class="user-dashbaord-body">
        <div class="container">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex flex-wrap align-items-center justify-content-between gap-3">
                        <div>
                            <h6 class="mb-1">{{ $support->title }}</h6>
                            <ul class="d-flex flex-wrap gap-sm-3 gap-2 align-items-center text-sm">
                                <li class="text-primary fw-semibold"><i class="ri-hashtag"></i> {{ $support->trx }}
                                </li>
                                <li><i class="ri-calendar-line"></i> {{ dateFormatter($support->created_at) }}</li>

                                @if ($support->status == cons()::INACTIVE)
                                    <span class="badge badge-light-success">{{ tt_front('Open') }}</span>
                                @elseif($support->status == cons()::ACTIVE)
                                    <span class="badge badge-light-success">{{ tt_front('Answered') }}</span>
                                @else
                                    <span class="badge badge-light-danger">{{ tt_front('Closed') }}</span>
                                @endif
                            </ul>
                        </div>
                        <div>
                            <a href="{{ route('support.index') }}" class="text-sm fw-semibold">
                                <i class="ri-arrow-left-line"></i>
                                {{ tt_front('Back') }}
                            </a>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="all-reply-body">
                        @foreach ($support->messages as $message)
                            @if ($message->type == 'user')
                                <div class="d-sm-flex gap-3 border border-light bg-light-extra-light p-3 rounded-3">
                                    <img src="{{ getFile('user', $message->support->user->image) }}" alt="user image"
                                        class="avatar-xl flex-shrink-0">
                                    <div class="flex-grow-1 mt-sm-0 mt-2">
                                        <div class="d-flex flex-wrap align-items-center gap-2 justify-content-between mb-2">
                                            <h6 class="mb-0 text-md">{{ $message->support->user->username }}</h6>
                                            <span class="text-sm">{{ $message->created_at->diffforhumans() }}</span>
                                        </div>
                                        <p class="mb-0">{{ $message->message }}</p>
                                        <div class="d-flex flex-wrap gap-sm-3 gap-2 align-items-center mt-2">
                                            @foreach ($message->files as $file)
                                                <a href="{{ route('support.download', $file->id) }}" class="text-primary"><i class="ri-file-line"></i> {{ $file->file }}</a>
                                            @endforeach
                                        </div>
                                    </div>
                                </div><!-- csutomer reply -->
                                @if (!$loop->last)
                                    <hr>
                                @endif
                            @else
                                <div class="d-sm-flex gap-3 border border-light-primary bg-light-extra-light p-3 rounded-3">
                                    <img src="{{ getFile('staff', $message->admin->image) }}" alt="user image"
                                        class="avatar-xl flex-shrink-0">
                                    <div class="flex-grow-1 mt-sm-0 mt-2">
                                        <div class="d-flex flex-wrap align-items-center gap-2 justify-content-between mb-2">
                                            <h6 class="mb-0 text-md">{{ $message->admin->username }}</h6>
                                            <span class="text-sm">{{ $message->created_at->diffforhumans() }}</span>
                                        </div>
                                        <p class="mb-0">{{ $message->message }}
                                        </p>
                                        <div class="d-flex flex-wrap gap-sm-3 gap-2 align-items-center mt-2">
                                            @foreach ($message->files as $file)
                                                <a href="{{ route('panel.support.download', $file->id) }}"
                                                    class="text-primary"><i class="ri-file-line"></i>
                                                    {{ $file->file }}</a>
                                            @endforeach
                                        </div>
                                    </div>
                                </div><!-- admin reply -->
                                <hr>
                            @endif
                        @endforeach

                    </div>
                </div>
                @if ($support->status != cons()::SUPPORT_CLOSED)
                    <div class="card-footer">
                        <form method="POST" action="{{ route('support.reply', $support->id) }}"
                            enctype="multipart/form-data">
                            @csrf
                            <textarea name="message" cols="6" rows="6" class="form-control" placeholder="Write Reply...">{{ old('message') }}</textarea>

                            <div id="allFiles">

                            </div>

                            <div class="d-flex flex-wrap align-items-center justify-content-end gap-2 mt-3">
                                <button type="button" id="addFiles" class="btn btn-sm btn-light-primary"><i
                                        class="ri-file-add-line"></i>
                                    {{ tt_front('Add Files') }}</button>
                                <button type="submit" class="btn btn-sm btn-primary"><i class="ri-reply-line"></i>
                                    {{ tt_front('Reply') }}</button>
                            </div>
                        </form>
                    </div>
                @endif
            </div>
        </div>
    </div>
@endsection


@push('script')
    <script>
        'use strict';
        $(document).ready(function() {
            // Function to add a file
            $('#addFiles').on('click', function() {
                $('#allFiles').append(`
                <div class="mt-3 single-file d-flex align-items-end gap-2">
                    <div class="flex-grow-1">
                        <input class="form-control form-control-sm" type="file" name="files[]">
                    </div>
                    <button type="button" class="btn btn-sm btn-danger flex-shrink-0"><i class="ri-close-line"></i></button>
                </div>
            `);
            });

            // Function to remove a file
            $(document).on('click', '.btn-danger', function() {
                $(this).closest('.single-file').remove();
            });
        });
    </script>
@endpush
