@extends('frontend::layouts.user_master')

@section('content')
    <div class="user-dashbaord-body">
        <div class="container">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex flex-wrap align-items-center justify-content-between gap-3">
                        <h4 class="card-title mb-0">{{ tt_front('All Tickets') }}</h4>
                        <div class="d-flex flex-wrap align-items-center gap-3">
                            <form method="GET">
                                <div class="d-flex flex-wrap align-items-center gap-2">
                                    <div class="flex-grow-sm-0 flex-grow-1">
                                        <select class="form-select form-select-sm" name="sort">
                                            <option value="all">{{tt_front('All')}}</option>
                                            <option value="open">{{tt_front('Open')}}</option>
                                            <option value="answered">{{tt_front('Answered')}}</option>
                                            <option value="closed">{{tt_front('Closed')}}</option>
                                        </select>
                                    </div>
                                    <div class="position-relative flex-grow-1">
                                        <input type="text" name="trx" class="form-control form-control-sm ps-35"
                                            placeholder="Ticket ID...">
                                        <span class="position-absolute top-middle start-10">
                                            <i class="ri-search-line"></i>
                                        </span>
                                    </div>

                                    <button type="submit" class="flex-grow-1 btn btn-sm btn-primary-gradient display-color rounded">
                                        <i class="ri-filter-line"></i> {{tt_front('Filter')}}
                                    </button>
                                </div>
                            </form>
                            <a href="{{ route('support.create') }}" class="btn btn-sm btn-primary rounded">
                                <i class="ri-add-line"></i> {{ tt_front('Add New') }}
                            </a>
                        </div>
                    </div>

                    <div class="mt-4">
                        @forelse ($supports as $support)
                            <div class="col-12">
                                <div class="d-flex flex-wrap align-items-center justify-content-between gap-3">
                                    <div class="d-flex align-items-center gap-3">
                                        <div
                                            class="avatar-xl bg-primary rounded-circle item-center text-white text-xxl flex-shrink-0">
                                            <iconify-icon icon="ph:ticket-duotone"></iconify-icon>
                                        </div>
                                        <div class="flex-grow-1">
                                            <h6 class="mb-1">{{ $support->title }}</h6>
                                            <p class="mb-0 text-sm d-flex flex-wrap align-items-center gap-3">
                                                <span class="fw-semibold">#{{ $support->trx }}</span>
                                                <span>{{ $support->created_at->diffforhumans() }}</span>
                                                @if ($support->status == cons()::SUPPORT_OPEN)
                                                    <span class="badge badge-light-success">{{ tt_front('Open') }}</span>
                                                @elseif($support->status == cons()::SUPPORT_ANSWERED)
                                                    <span
                                                        class="badge badge-light-success">{{ tt_front('Answered') }}</span>
                                                @else
                                                    <span
                                                        class="badge badge-light-danger">{{ tt_front('Closed') }}</span>
                                                @endif
                                            </p>
                                        </div>
                                    </div>
                                    <a href="{{route('support.show',$support->id)}}" class="btn btn-sm btn-outline-secondary">
                                        {{tt_front('View')}} <i class="ri-arrow-right-s-line"></i>
                                    </a>
                                </div>
                            </div>
                            <hr>
                        @empty

                        <tr>
                            <td colspan="6" class="text-center">
                                <div class="no-data-wrapper">
                                    <span class="icon">
                                        <iconify-icon icon="hugeicons:property-search"></iconify-icon>
                                    </span>
                                    <p class="mb-0 mt-2">{{ tt_front("Don't have data") }}</p>
                                </div>
                            </td>
                        </tr>

                        @endforelse

                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
