<div class="mb-3 mt-3">
    <label class="form-label">{{ tt_front('Withdraw amount') }}</label>
    <input type="number" step="any" name="amount" class="form-control amount" placeholder="Enter Withdraw Amount"
        value="{{ formatter($method->min_amount) }}" data-charge="{{ $method->charge }}" data-type="{{ $method->type }}">
</div>
<div class="border mt-3 mb-3 p-3 rounded-2 extra-light-bg">
    <h6 class="text-sm mb-3">{{ tt_front('Withdraw method information') }}:</h6>
    <div class="row">
        <div class="col-lg-6">
            <ul class="text-xs d-flex flex-column gap-2">
                <li class="d-flex align-items-center">
                    <span class="w-50 text-muted">{{ tt_front('Currency') }}</span>
                    <span class="w-50 display-color fw-medium">{{ $method->currency }}</span>
                </li>
                <li class="d-flex align-items-center">
                    <span class="w-50 text-muted">{{ tt_front('Charge') }}</span>
                    <span
                        class="w-50 display-color fw-medium">{{ $method->type == cons()::FIXED ? formatter($method->charge, true) : formatter($method->charge) . '%' }}</span>
                </li>

                <li class="d-flex align-items-center">
                    <span class="w-50 display-color fw-bold">{{ tt_front('Current Balance') }}</span>
                    <span class="w-50 display-color fw-bold">{{ formatter(user()->balance, true) }}</span>
                </li>
            </ul>
        </div>
        <div class="col-lg-6">
            <ul class="text-xs d-flex flex-column gap-2">
                <li class="d-flex align-items-center">
                    <span class="w-50 text-muted">{{ tt_front('Minimum Withdraw') }}</span>
                    <span class="w-50 display-color fw-medium">{{ formatter($method->min_amount, true) }}</span>
                </li>
                <li class="d-flex align-items-center">
                    <span class="w-50 text-muted">{{ tt_front('Maximum Withdraw') }}</span>
                    <span class="w-50 display-color fw-medium">{{ formatter($method->max_amount, true) }}</span>
                </li>

                <li class="d-flex align-items-center">
                    <span class="w-50 text-muted">{{ tt_front('You Will Get') }}</span>
                    <span
                        class="w-50 display-color fw-medium getableAmount">{{ $method->type == cons()::FIXED ? formatter($method->min_amount - $method->charge, true) : formatter($method->min_amount - ($method->min_amount * $method->charge) / 100, true) }}</span>
                </li>
            </ul>
        </div>
    </div>
</div>

<div class="border mt-3 mb-3 p-3 rounded-2 extra-light-bg">
    <h6 class="text-sm mb-3">{{ tt_front('Withdraw instruction') }}:</h6>
    <div class="text-sm">
        <p class="mb-0">
            <?= $method->instruction ?>
        </p>
    </div>
</div>
