@extends('frontend::layouts.user_master')

@section('content')
    <div class="user-dashbaord-body">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <div class="card">
                        <div class="card-header">
                            <div class="send-money-steps steps-three">
                                <div class="send-money-single-step active">
                                    <span class="send-money-single-step-amount">1</span>
                                    <span class="send-money-single-step-caption">{{tt_front('Methods')}}</span>
                                </div>
                                <div
                                    class="send-money-single-step active">
                                    <span class="send-money-single-step-amount">2</span>
                                    <span class="send-money-single-step-caption">{{tt_front('Overview')}}</span>
                                </div>
                                <div
                                    class="send-money-single-step active">
                                    <span class="send-money-single-step-amount">3</span>
                                    <span class="send-money-single-step-caption">{{tt_front('Withdraw')}}</span>
                                </div>
                            </div>
                        </div>
                        <div class="card-body py-sm-4">
                            <div class="like-container">
                                <div class="like-thumb">
                                    <div class="like-thumb-inner">
                                        <iconify-icon icon="ant-design:like-twotone"></iconify-icon>
                                    </div>
                                </div>
                            </div>

                            <div class="text-center">
                                <h3 class="mt-4">{{tt_front('Withdraw Successfully Done')}}</h3>
                                <p>{{tt_front('Please wait untill admin confirms your withdraw request')}}.</p>
                            </div>

                            <div class="row justify-content-center">
                                <div class="col-xxl-9">
                                    <div class="border mt-4 p-3 rounded-2  extra-light-bg">
                                        <div class="row gy-2">
                                            <div class="col-md-6">
                                                <div class="p-2">
                                                    <span
                                                        class="text-sm text-muted">{{ tt_front('Recipient Name') }}</span>
                                                    <p class="mb-0 fw-semibold">
                                                        {{ App\Models\User::find(session('withdraw')['user_id'])->username }}
                                                    </p>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="p-2">
                                                    <span class="text-sm text-muted">{{ tt_front('TRX ID') }}</span>
                                                    <p class="mb-0 fw-semibold">{{ session('withdraw')['trx'] }}</p>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="p-2">
                                                    <span
                                                        class="text-sm text-muted">{{ tt_front('Withdraw Amount') }}</span>
                                                    <p class="mb-0 fw-semibold">
                                                        {{ symbol(session('withdraw')['withdraw_amount']) }}
                                                    </p>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="p-2">
                                                    <span
                                                        class="text-sm text-muted">{{ tt_front('Withdraw Charge') }}</span>
                                                    <p class="mb-0 fw-semibold">
                                                        {{ symbol(session('withdraw')['charge']) }}</p>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="p-2">
                                                    <span
                                                        class="text-sm text-muted">{{ tt_front('Withdraw Method') }}</span>
                                                    <p class="mb-0 fw-semibold">
                                                        {{ App\Models\WithdrawMethod::find(session('withdraw')['method_id'])->name }}
                                                    </p>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="p-2">
                                                    <span
                                                        class="text-sm text-muted">{{ tt_front('Getable Amount') }}</span>
                                                    <p class="mb-0 fw-semibold text-success">
                                                        {{ symbol(session('withdraw')['getable_amount']) }}
                                                    </p>
                                                </div>
                                            </div>


                                            <div class="col-md-6">
                                                <div class="p-2">
                                                    <span
                                                        class="text-sm text-muted">{{ tt_front('Currency Rate') }}</span>
                                                    <p class="mb-0 fw-semibold">
                                                        {{ symbol(session('withdraw')['rate'])}}
                                                    </p>
                                                </div>
                                            </div>

                                            <div class="col-md-6">
                                                <div class="p-2">
                                                    <span
                                                        class="text-sm text-muted">{{ tt_front('Total Amount in Method Currency') }}</span>
                                                    <p class="mb-0 fw-semibold">
                                                        {{ symbol(session('withdraw')['getable_amount_in_method_currency'],App\Models\WithdrawMethod::find(session('withdraw')['method_id'])->currency, App\Models\WithdrawMethod::find(session('withdraw')['method_id'])->currency_type)}}
                                                    </p>
                                                </div>
                                            </div>

                                            <div class="col-md-6">
                                                <div class="p-2">
                                                    <span
                                                        class="text-sm text-muted">{{ tt_front('Status') }}</span>
                                                    <p class="mb-0 fw-semibold text-warning">
                                                        {{tt_front('Pending') }}
                                                    </p>
                                                </div>
                                            </div>


                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div
                                class="d-flex flex-wrap align-items-center justify-content-center align-items-center gap-3 mt-4">

                                <a href="{{route('withdraw-log')}}" class="btn btn-md btn-primary-gradient">{{tt_front('Back to Withdraw Log')}} <i
                                        class="ri-arrow-right-line"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
@endsection

@push('script')
    <script>
        $(function() {
            'use strict'

            function fetchInstruction(route) {
                $.ajax({
                    method: 'GET',
                    url: route,
                    success: function(response) {
                        $('#instruction').html(response)
                    }
                })
            }

            fetchInstruction($('.selectMethod:checked').data('url'))

            $('.selectMethod').on('click', function() {
                fetchInstruction($(this).data('url'));
            })



            $(document).on('keyup', '.amount', function() {
                let getAbleAmount = $(this).val() - $(this).data('charge') +
                    ' ' + "{{ tc()->get('currency') }}"
                $('.getableAmount').text(getAbleAmount)
            })


            function withdrawStep(step) {
                $.ajax({
                    method: "GET",
                    url: "{{ route('session-remover') }}",
                    data: {
                        withdraw_step: step
                    },
                    success: function() {
                        window.location.href = "{{ url()->current() }}"
                    }
                })
            }

        })
    </script>
@endpush
