@extends('frontend::layouts.user_master')

@section('content')
    <div class="user-dashbaord-body">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <div class="card">
                        <div class="card-header">
                            <div class="send-money-steps steps-three">
                                <div class="send-money-single-step">
                                    <span class="send-money-single-step-amount">1</span>
                                    <span class="send-money-single-step-caption">{{ tt_front('Methods') }}</span>
                                </div>
                                <div class="send-money-single-step">
                                    <span class="send-money-single-step-amount">2</span>
                                    <span class="send-money-single-step-caption">{{ tt_front('Overview') }}</span>
                                </div>
                                <div class="send-money-single-step">
                                    <span class="send-money-single-step-amount">3</span>
                                    <span class="send-money-single-step-caption">{{ tt_front('Withdraw') }}</span>
                                </div>
                            </div>
                        </div>

                        <div class="card-body py-sm-4">
                            <div class="text-center mb-4">
                                <h3>{{ tt_front('Withdraw Money') }}</h3>
                                <p>{{tt_front('Fast and reliable international money transfer app.')}}</p>
                            </div>

                            <form method="POST">
                                @csrf
                                <label class="form-label">{{ tt_front('Withdraw method') }}</label>
                                <div class="row g-3">
                                    @foreach ($methods as $method)
                                        <div class="col-lg-4 col-md-6">
                                            <div class="recipient-single">
                                                <img src="{{ getFile('withdraw', $method->image) }}" alt="image"
                                                    class="recipient-single-thumb">
                                                <div class="recipient-single-content">
                                                    <h6 class="text-md mb-1">{{ $method->name }}</h6>
                                                    <p class="mb-0 text-xs">{{ tt_front('Currency') }}:
                                                        {{ $method->currency }}</p>
                                                </div>
                                                <div class="form-check">
                                                    <input class="form-check-input selectMethod"
                                                        data-currency="{{ $method->currency }}" type="radio"
                                                        name="method" value="{{ $method->id }}"
                                                        id="recipient-{{ $method->id }}" {{$loop->first ? 'checked' : '' }}
                                                        data-url="{{ route('fetch-withdraw-instruction', $method->id) }}">
                                                    <label class="form-check-label"
                                                        for="recipient-{{ $method->id }}"></label>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach

                                </div>


                                <div id="instruction">

                                </div>

                                <div class="mb-3">
                                    <label class="form-label">{{ tt_front('Account information') }}</label>
                                    <textarea name="note" placeholder="{{tt_front('Enter Additional Information')}}" cols="6" rows="4" class="form-control"></textarea>
                                </div>
                                <div
                                    class="d-flex flex-wrap align-items-center justify-content-end align-items-center gap-2 mt-4">
                                    <button type="submit"
                                        class="btn btn-md btn-primary-gradient stepOne">{{ tt_front('Next') }}
                                        <i class="ri-arrow-right-line"></i></button>
                                </div>
                            </form>

                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
@endsection

@push('script')
    <script>
        $(function() {
            'use strict'

            function fetchInstruction(route) {
                $.ajax({
                    method: 'GET',
                    url: route,
                    success: function(response) {
                        $('#instruction').html(response)
                    }
                })
            }

            fetchInstruction($('.selectMethod:checked').data('url'))

            $('.selectMethod').on('click', function() {
                fetchInstruction($(this).data('url'));
            })



            $(document).on('keyup', '.amount', function() {

                let getAbleAmount = 0;

                if ($(this).data('type') == 1) {
                    getAbleAmount = $(this).val() - $(this).data('charge') +
                        ' ' + "{{ tc()->get('currency') }}"
                } else {
                    getAbleAmount = $(this).val() - ($(this).val() * $(this).data('charge') / 100) +
                        ' ' + "{{ tc()->get('currency') }}"
                }

                $('.getableAmount').text(getAbleAmount)
            })


        })
    </script>
@endpush
