
@if ($paginator->hasPages())
    <div class="pagination-style-two d-flex justify-content-end">
        <nav aria-label="Page navigation example">
            <ul class="pagination">
                @if ($paginator->onFirstPage())
                    <li class="page-item"><a class="page-link" href="#">
                            <i class="ri-arrow-left-s-line"></i>
                        </a></li>
                @else
                    <li class="page-item"><a class="page-link" href="{{ $paginator->previousPageUrl() }}">
                            <i class="ri-arrow-left-s-line"></i>
                        </a></li>
                @endif

                @foreach ($elements as $element)
                
                    @if (is_string($element))
                        <li class="disabled" aria-disabled="true"><span>{{ $element }}</span></li>
                    @endif

                    @if (is_array($element))
                        @foreach ($element as $page => $url)
                            @if ($page == $paginator->currentPage())
                                <li class="page-item active"><a class="page-link" href="#">{{ $page }}</a>
                                </li>
                            @else
                                <li class="page-item"><a class="page-link"
                                        href="{{ $url }}">{{ $page }}</a></li>
                            @endif
                        @endforeach
                    @endif
                @endforeach
                @if ($paginator->hasMorePages())
                    <li class="page-item"><a class="page-link" href="{{ $paginator->nextPageUrl() }}">
                            <i class="ri-arrow-right-s-line"></i>
                        </a></li>
                @else
                    <li class="page-item disabled" aria-disabled="true" aria-label="@lang('pagination.next')">
                        <a href="#" class="page-link">
                            <i class="ri-arrow-right-s-line"></i>
                        </a>
                    </li>
                @endif

            </ul>
        </nav>
    </div>
@endif
