<?php

use App\Http\Controllers\Backend\Addon\AddonController;
use App\Http\Controllers\Backend\Auction\AuctionController;
use App\Http\Controllers\Backend\Admins\AdminController;
use App\Http\Controllers\Backend\Auth\ForgotPasswordController;
use App\Http\Controllers\Backend\Auth\LoginController;
use App\Http\Controllers\Backend\Blog\BlogCategoryController;
use App\Http\Controllers\Backend\Blog\BlogController;
use App\Http\Controllers\Backend\Cms\ContentManagementController;
use App\Http\Controllers\Backend\Currency\CurrencyController;
use App\Http\Controllers\Backend\Deposit\ManageDepositController;
use App\Http\Controllers\Backend\Email\EmailConfigurationController;
use App\Http\Controllers\Backend\Email\EmailTemplateController;
use App\Http\Controllers\Backend\Gateway\GatewayController;
use App\Http\Controllers\Backend\IcoSetting\IcoSettingController;
use App\Http\Controllers\Backend\Kyc\KycRequestController;
use App\Http\Controllers\Backend\Language\LanguageController;
use App\Http\Controllers\Backend\Menu\MenuController;
use App\Http\Controllers\Backend\Notification\NotificationController;
use App\Http\Controllers\Backend\Others\OthersController;
use App\Http\Controllers\Backend\Page\PagesController;
use App\Http\Controllers\Backend\PanelController;
use App\Http\Controllers\Backend\Payment\PaymentController;
use App\Http\Controllers\Backend\Referral\ReferralController;
use App\Http\Controllers\Backend\Reports\ReportController;
use App\Http\Controllers\Backend\Role\RoleController;
use App\Http\Controllers\Backend\Settings\SettingsController;
use App\Http\Controllers\Backend\Stage\StageController;
use App\Http\Controllers\Backend\Support\SupportController;
use App\Http\Controllers\Backend\Theme\ThemesController;
use App\Http\Controllers\Backend\Update\UpdateController;
use App\Http\Controllers\Backend\User\UserController;
use App\Http\Controllers\Backend\Withdraw\WithdrawController;
use App\Http\Controllers\Backend\Withdraw\WithdrawMethodController;
use Illuminate\Support\Facades\Route;

Route::as('panel.')->group(function () {
    Route::middleware(['is_not_admin'])->group(function () {
        Route::controller(LoginController::class)->group(function () {
            Route::get('login', 'loginPage')->name('login');
            Route::post('login', 'login');
        });

        Route::controller(ForgotPasswordController::class)->group(function () {
            Route::get('forgot-password', 'forgotPassword')->name('forgot-password');
            Route::post('forgot-password', 'sendResetCode')->middleware('is_send_code_already');
            Route::get('verify-code', 'verifyCode')->name('verify-code');
            Route::post('verify-code', 'verifyCodeConfirmation');
            Route::get('reset-password', 'resetPassword')->name('reset-password');
            Route::post('reset-password', 'resetPasswordConfirmation');
        });
    });

    Route::middleware(['is_admin', 'is_admin_active', 'demo'])->group(function () {
        Route::controller(PanelController::class)->group(function () {
            Route::get('dashboard', 'dashboard')->name('dashboard');

            Route::get('admin-profile', 'adminProfile')->name('admin-profile');
            Route::post('admin-profile-update', 'adminProfileUpdate')->name('admin-profile-update');
            Route::post('admin-password-update', 'adminPasswordUpdate')->name('admin-password-update');

            Route::get('logout', 'logout')->name('logout');
        });



        Route::controller(RoleController::class)->group(function () {
            Route::resource('roles', RoleController::class);
            Route::get('permission-fetch', 'permissionFetch')->name('permission.fetch');
        });

        Route::controller(AdminController::class)->group(function () {
            Route::resource('admins', AdminController::class);
            Route::get('get-options', 'getOptions')->name('get.options');
        });

        Route::controller(SettingsController::class)->group(function () {
            Route::get('settings', 'settings')->name('settings');
            Route::post('settings', 'settingsUpdate');
            Route::post('plugin-update', 'pluginUpdate')->name('plugin-update');
            Route::post('kyc-update', 'kycUpdate')->name('kyc-update');
            Route::post('seo-update', 'seoUpdate')->name('seo-update');
            Route::post('maintanance-update', 'maintananceUpdate')->name('maintanance-update');
            Route::post('invoice-builder', 'invoiceBuilder')->name('invoice-builder');
            Route::post('card-update', 'cardUpdate')->name('card-update');
        });

        Route::resource('currency', CurrencyController::class);

        Route::controller(IcoSettingController::class)->group(function () {
            Route::get('ico-setting', 'setting')->name('ico.setting');
            Route::post('ico-setting', 'settingUpdate');
        });

        Route::resource('stage', StageController::class);

        Route::controller(StageController::class)->group(function () {
            Route::get('stage/purhchase/list', 'purchases')->name('stage.purchases');
        });

        Route::controller(EmailConfigurationController::class)->group(function () {
            Route::get('email-config', 'emailConfig')->name('email.config');
            Route::get('email-global-template-load', 'emailGlobalTemplateLoad')->name('email-global-template-load');
            Route::post('email-config', 'emailConfigUpdate');
        });

        Route::controller(EmailTemplateController::class)->group(function () {
            Route::get('email-template/{key}', 'emailTemplate')->name('email.template');
            Route::post('email-template/{key}', 'emailTemplateUpdate');
        });

        Route::controller(ReferralController::class)->group(function () {
            Route::get('referral-settings', 'referralSettings')->name('referral-settings');
            Route::post('referral-settings', 'referralSettingsUpdate');
            Route::post('referral-level-create', 'referralLevelStore')->name('referral-level-store');
            Route::post('referral-level-create/{levelid}', 'referralLevelUpdate')->name('referral-level-update');
            Route::delete('referral-level-delete/{levelid}', 'referralLevelDelete')->name('referral-level-delete');
        });

        Route::controller(LanguageController::class)->group(function () {
            Route::resource('language', LanguageController::class);
            Route::get('translate/{code}', 'translate')->name('translate');
            Route::post('translate/{code}', 'translateUpdate');
            Route::get('sync-translation', 'syncTranslation')->name('sync-translation');
            Route::get('translation-search', 'translationSearch')->name('translation-search');
        });

        Route::controller(WithdrawMethodController::class)->group(function () {
            Route::resource('withdraw', WithdrawMethodController::class);
            Route::post('method-fetch', 'methodFetch')->name('method-fetch');
        });

        Route::controller(WithdrawController::class)->group(function () {
            Route::get('withdraw-request', 'withdrawRequest')->name('withdraw-request');

            Route::post('withdraw-accept/{id}', 'withdrawAccept')->name('withdraw-accept');
            Route::post('withdraw-reject/{id}', 'withdrawReject')->name('withdraw-reject');

            Route::get('withdraw-details', 'withdrawDetails')->name('withdraw-details');
        });

        Route::controller(PagesController::class)->group(function () {
            Route::resource('page', PagesController::class);
        });

        Route::controller(MenuController::class)->group(function () {
            Route::get('menu', 'menu')->name('menu');
            Route::post('menu', 'menuUpdate');
        });

        Route::controller(GatewayController::class)->group(function () {
            Route::get('gateways', 'gateways')->name('gateways');
            Route::get('gateways/{id}', 'gatewayEdit')->name('gateway.edit');
            Route::post('gateways/{id}', 'gatewayUpdate');
            Route::get('offline-gateways', 'offlineGateways')->name('offline-gateways');
            Route::get('offline-gateway/create', 'offlineGatewayCreate')->name('offline-gateway-create');
            Route::post('offline-gateway/create', 'offlineGatewayStore');
            Route::post('offline-gateway/edit/{id}', 'offlineGatewayUpdate')->name('offline-gateway-update');
        });

        Route::controller(UserController::class)->group(function () {
            Route::get('users', 'users')->name('users');
            Route::get('users/{id}', 'userDetails')->name('user.details');

            Route::post('bulk-mail', 'bulkMail')->name('bulk-mail');
            Route::delete('delete-user/{user}', 'deleteUser')->name('delete.user');

            Route::post('add-balance/{user}', 'addBalance')->name('add-balance');
            Route::post('sub-balance/{user}', 'subBalance')->name('sub-balance');
            Route::post('send-mail/{user}', 'sendMail')->name('send-mail');
            Route::post('update-user-profile/{user}', 'updateUserProfile')->name('update-user-profile');

            Route::get('login-as-user/{id}', 'loginAsUser')->name('login-as-user');
        });

        Route::controller(KycRequestController::class)->group(function () {
            Route::get('kyc-verification-request', 'kycVerificationRequest')->name('kyc-verification-request');
            Route::get('kyc-verification-details/{id}', 'kycVerificationDetails')->name('kyc-verification-details');
            Route::post('kyc-verification-accept/{id}', 'kycVerificationAccept')->name('kyc-verification-accept');
            Route::post('kyc-verification-reject/{id}', 'kycVerificationReject')->name('kyc-verification-reject');
        });

        Route::controller(OthersController::class)->group(function () {
            Route::post('change-status', 'changeStatus')->name('changeStatus');
            Route::get('system-version', 'systemVersion')->name('system-version');
            Route::get('clear-cache', 'clearCache')->name('clear-cache');

            Route::get('subscribers', 'subscribers')->name('subscribers');
            Route::post('subscriber-bulk-mail', 'subscriberBulkMail')->name('subscriber-bulk-mail');
            Route::post('subscriber-mail/{id}', 'subscriberMail')->name('subscriber-mail');

            Route::post('editor-image', 'editorImage')->name('editor-image');

            Route::get('mark-as-all-read', 'markAsAllRead')->name('mark-as-all-read');

            Route::get('crypto', 'fetchCryptoCurrencies')->name('crypto');

            Route::get('contact', 'contact')->name('contact');
        });

        Route::controller(BlogCategoryController::class)->group(function () {
            Route::resource('blog-category', BlogCategoryController::class);
        });

        Route::controller(BlogController::class)->group(function () {
            Route::resource('blogs', BlogController::class);
        });

        Route::controller(SupportController::class)->group(function () {
            Route::get('support', 'support')->name('support');
            Route::get('support/details/{id}', 'supportDetails')->name('support-details');
            Route::get('support/download/{supportFile}', 'supportFileDownload')->name('support.download');
            Route::post('support/reply/{support}', 'supportReply')->name('support.reply');
            Route::post('support/closed/{support}', 'supportClosed')->name('support.closed');
        });

        Route::controller(ManageDepositController::class)->group(function () {
            Route::get('offline-deposits', 'offlineDeposits')->name('offline-deposits');
            Route::get('offline-deposit-details/{id}', 'offlineDepositDetails')->name('offline-deposit-details');
            Route::post('offline-deposit-accept/{id}', 'offlineDepositAccept')->name('offline-deposit-accept');
            Route::post('offline-deposit-reject/{id}', 'offlineDepositReject')->name('offline-deposit-reject');
            Route::get('online-deposits', 'onlineDeposits')->name('online-deposits');
            Route::get('online-deposits-details/{id}', 'onlineDepositDetails')->name('online-deposit-details');
        });

        Route::controller(PaymentController::class)->group(function () {
            Route::get('pending-purchases', 'pendingPurchases')->name('offline-pending-purchase');
            Route::get('reject-purchases', 'rejectPurchase')->name('offline-reject-purchase');
            Route::get('completed-purchases', 'completedPurchase')->name('offline-completed-purchase');
            Route::get('purchase-details/{id}', 'offlinePaymentDetails')->name('offline-purchase-details');
            Route::post('offline-purchase-accept/{id}', 'offlinePaymentAccept')->name('offline-purchase-accept');
            Route::post('offline-purchase-reject/{id}', 'offlinePaymentReject')->name('offline-purchase-reject');
        });

        Route::controller(AuctionController::class)->group(function () {
            Route::get('auction/history', 'history')->name('auction.history');
            Route::get('auction/running','runningAuction')->name('auction.running');
        });


        Route::controller(NotificationController::class)->group(function () {
            Route::get('notifications', 'notifications')->name('notifications');
            Route::get('notifications-read/{id}', 'notificationMarkAsRead')->name('notification-read');
        });

        Route::controller(ContentManagementController::class)->group(function () {

            Route::get('content-update/{section}', 'content')->name('content');

            Route::post('content-update/{section}', 'contentUpdate')->name('content-update');

            Route::get('content-create/{section}', 'contentCreate')->name('content-create');
            Route::post('content-create/{section}', 'contentStore');

            Route::get('element-update/{id}', 'elementEdit')->name('element-edit');
            Route::post('element-update/{id}', 'elementUpdate');

            Route::delete('element-delete/{section}', 'contentDelete')->name('element-delete');
        });

        Route::controller(ThemesController::class)->group(function () {
            Route::get('theme', 'theme')->name('theme');
            Route::post('theme', 'themeUpdate');
        });

        Route::controller(ReportController::class)->group(function () {
            Route::get('transactions-report', 'transactionsReport')->name('transactions-report');
            Route::get('referral-commission-report', 'referralCommissionReport')->name('referral-commission-report');
            Route::get('user-earnings-report', 'userEarningsReport')->name('user-earnings-report');
            Route::get('user-logins-report', 'userLoginsReport')->name('user-logins-report');
        });

        Route::controller(UpdateController::class)->group(function () {
            Route::post('update', 'update')->name('update');
            Route::post('upload-file', 'uploadFile')->name('upload-file');
        });


        Route::controller(AddonController::class)->group(function () {
            Route::get('addons', 'addon')->name('addons');
            Route::get('install-addon/{id}', 'installAddon')->name('install-addon');
            Route::post('install-addon/{id}', 'installAddonStore');
            Route::post('addon-status/{id}', 'changeStatus')->name('addon-status');
        });

    });
});
