<?php

use App\Http\Controllers\Installer\InstallerController;
use Illuminate\Support\Facades\Route;

Route::middleware('is_installed')->controller(InstallerController::class)->group(function () {

    Route::get('installer', 'installer')->name('installer');

    Route::get('extensions', 'extensions')->name('extensions');

    Route::get('permissions', 'permissions')->name('permissions');

    Route::get('database', 'database')->name('database');

    Route::post('database', 'install');

    Route::get('credentials', 'credentials')->name('credentials');

    Route::post('credentials', 'credentialStore');

    Route::get('install-success', 'installSuccess')->name('install-success')->withoutMiddleware('is_installed')->middleware('signed');
});
