<?php

use App\Http\Controllers\CommonController;
use App\Http\Controllers\CronController;
use App\Http\Controllers\Frontend\Auction\AuctionController;
use App\Http\Controllers\Frontend\Auth\ForgetPasswordController;
use App\Http\Controllers\Frontend\Auth\LoginController;
use App\Http\Controllers\Frontend\Auth\RegistrationController;
use App\Http\Controllers\Frontend\Authorize\AuthorizationController;
use App\Http\Controllers\Frontend\DashboardController;
use App\Http\Controllers\Frontend\Deposit\DepositController;
use App\Http\Controllers\Frontend\HomeController;
use App\Http\Controllers\Frontend\Ipn\IpnController;
use App\Http\Controllers\Frontend\Log\LogController;
use App\Http\Controllers\Frontend\Message\MessageController;
use App\Http\Controllers\Frontend\Payment\PaymentController;
use App\Http\Controllers\Frontend\Profile\UserProfileController;
use App\Http\Controllers\Frontend\Referral\ReferralController;
use App\Http\Controllers\Frontend\Socialite\FacebookLoginController;
use App\Http\Controllers\Frontend\Socialite\GoogleLoginController;
use App\Http\Controllers\Frontend\Stage\StageController;
use App\Http\Controllers\Frontend\Support\SupportController;
use App\Http\Controllers\Frontend\TwoFA\TwoFAAuthenticationController;
use App\Http\Controllers\Frontend\Withdraw\WithdrawController;
use Illuminate\Support\Facades\Route;

Route::middleware(['maintanance_mode'])->group(function () {
    Route::middleware('guest')->group(function () {
        Route::middleware('is_reg_off')
            ->controller(RegistrationController::class)
            ->group(function () {
                Route::get('registration/{username?}', 'registration')->name('registration');
                Route::post('registration/{username?}', 'registrationStore');
            });

        Route::controller(GoogleLoginController::class)->group(function () {
            Route::get('google/redirect', 'redirectToGoogle')->name('google.redirect');
            Route::get('google/callback', 'handleGoogleCallback')->name('google.callback');
        });

        Route::controller(FacebookLoginController::class)->group(function () {
            Route::get('facebook/redirect', 'redirectToFacebook')->name('facebook.redirect');
            Route::get('facebook/callback', 'handleFacebookCallback')->name('facebook.callback');
        });

        Route::controller(ForgetPasswordController::class)->group(function () {
            Route::get('forget-password', 'forgetPassword')->name('forget-password');
            Route::post('forget-password', 'sendVerificationCode')->middleware('is_send_code_already');
            Route::get('verify-code', 'verifyCode')->name('verify-code');
            Route::post('verify-code', 'verifyCodeConfirmation');
            Route::get('reset-password', 'resetPassword')->name('reset-password');
            Route::post('reset-password', 'resetPasswordConfirmation');
        });

        Route::controller(LoginController::class)->group(function () {
            Route::get('login', 'login')->name('login');
            Route::post('login', 'loginStore');
        });
    });

    Route::middleware(['auth', 'is_active'])->group(function () {
        Route::controller(AuthorizationController::class)->group(function () {
            Route::middleware('is_email_authorize')->group(function () {
                Route::get('email-verify', 'emailVerify')->name('email-verify');
                Route::post('email-verify', 'emailVerifyCode');
            });

            Route::middleware('is_sms_authorize')->group(function () {
                Route::get('sms-verify', 'smsVerify')->name('sms-verify');
                Route::post('sms-verify', 'smsVerifyCode');
            });

            Route::middleware('is_kyc_authorize')->group(function () {
                Route::get('kyc-verification', 'kycVerification')->name('kyc-verification');
                Route::post('kyc-verification', 'kycVerificationRequest');
            });
        });

        Route::middleware(['is_email_verified', 'is_sms_verified', 'is_kyc_verified', 'is_two_fa_enable'])->group(function () {

            Route::controller(DashboardController::class)->group(function () {
                Route::get('dashboard', 'dashboard')->name('dashboard');
                Route::get('logout', 'logout')->name('logout')->withoutMiddleware(['is_kyc_verified', 'is_email_verified', 'is_sms_verified']);
            });

            Route::controller(AuctionController::class)->group(function () {
                Route::get('auctions', 'auctions')->name('auctions');
                Route::get('auction/list', 'list')->name('auction.list');
                Route::get('auction/create', 'create')->name('auction.create');
                Route::post('auction/store', 'store')->name('auction.store');
                Route::get('auction/buy/{trx}', 'buy')->name('auction.buy');
                Route::post('auction/buy/{trx}', 'buyToken')->name('auction.buy.token');
                Route::get('auction/purchases', 'purchases')->name('auction.purchases');
                Route::get('auction/sell', 'sell')->name('auction.sell');
                Route::post('auction/withdraw/{trx}', 'withdraw')->name('auction.withdraw');
            });

            Route::controller(MessageController::class)->group(function () {
                Route::get('messages', 'messages')->name('messages');
                Route::get('message/reads', 'readMessages')->name('message.reads');
                Route::post('message', 'send')->name('message.send');
                Route::get('old/messages', 'oldMessages')->name('message.old');
            });

            Route::controller(UserProfileController::class)->group(function () {
                Route::get('profile', 'profile')->name('profile');
                Route::post('profile-image-update', 'profileImageUpdate')->name('profile-image-update');
                Route::post('profile-update', 'profileUpdate')->name('profile-update');
                Route::post('profile-address', 'profileAddress')->name('profile-address');

                Route::post('update-password', 'updatePassword')->name('update-password');
            });

            Route::controller(ReferralController::class)->group(function () {
                Route::get('referral', 'referral')->name('referral');
                Route::post('send-referral-link', 'sendReferralLink')->name('send-referral-link');
            });

            Route::controller(WithdrawController::class)->group(function () {
                Route::get('withdraw', 'withdraw')->name('withdraw');

                Route::get('fetch-withdraw-instruction/{id}', 'fetchWithdrawInstruction')->name('fetch-withdraw-instruction');

                Route::post('withdraw', 'makeWithdraw');

                Route::get('withdraw-overview', 'withdrawOverview')->name('withdraw-overview');

                Route::get('withdraw-final', 'withdrawFinal')->name('withdraw-final');

                Route::get('session-remover', 'sessionRemover')->name('session-remover');

                Route::post('withdraw-confirmation', 'withdrawConfirmation')->name('withdraw-confirmation');
            });

            Route::withoutMiddleware('is_two_fa_enable')
                ->controller(TwoFAAuthenticationController::class)
                ->group(function () {
                    Route::get('two-factor', 'twoFactor')->name('twofactor');

                    Route::post('enable-2fa', 'enableTwoFa')->name('enable-2fa');

                    Route::get('authentication', 'authentication')->name('authentication');

                    Route::post('authentication', 'verifyOtp');

                    Route::post('disable-two-factor-authentication', 'disableTwoFactorAuthentication')->name('disable-two-factor-authentication');
                });

            Route::controller(SupportController::class)->group(function () {
                Route::resource('support', SupportController::class);
                Route::get('support-download/{supportFile}', 'supportDownload')->name('support.download');
                Route::post('support-reply/{support}', 'supportReply')->name('support.reply');
            });

            Route::controller(LogController::class)->group(function () {
                Route::get('withdraw-log', 'withdrawLog')->name('withdraw-log');
                Route::get('transaction-log', 'transactionLog')->name('transaction-log');
                Route::get('deposit-log', 'depositLog')->name('deposit-log');
                Route::get('payment-log', 'paymentLog')->name('payment-log');
                Route::get('fetch-details', 'fetchDetails')->name('fetch-details');
                Route::get('referral-commission-log', 'referralCommissionLog')->name('referral-commission-log');
            });

            Route::controller(StageController::class)->group(function () {
                Route::get('purchase/stage', 'purchaseStage')->name('purchase.stage');
            });

            Route::controller(DepositController::class)->group(function () {

                Route::get('deposit', 'deposit')->name('deposit');

                Route::post('deposit', 'depositInitiate');

                Route::get('deposit-methods', 'depositMethods')->name('deposit-methods');

                Route::post('deposit-methods', 'depositStore');

                Route::get('deposit-instruction', 'depositInstruction')->name('deposit-instruction');

                Route::get('deposit-overview', 'depositOverview')->name('deposit-overview');

                Route::get('deposit-requirements', 'depositrequirements')->name('deposit-requirements');

                Route::post('deposit-overview', 'depositConfirmation');

                Route::get('deposit-final', 'depositFinal')->name('deposit-final');
            });


            Route::controller(PaymentController::class)->group(function () {

                Route::post('payment', 'paymentInitiate')->name('payment');

                Route::get('payment-methods', 'paymentMethods')->name('payment-methods');

                Route::post('payment-methods', 'paymentStore');

                Route::get('payment-instruction', 'paymentInstruction')->name('payment-instruction');

                Route::get('payment-overview', 'paymentOverview')->name('payment-overview');

                Route::get('payment-requirements', 'paymentrequirements')->name('payment-requirements');

                Route::post('payment-overview', 'paymentConfirmation');

                Route::get('payment-final', 'paymentFinal')->name('payment-final');
            });

            Route::controller(IpnController::class)->group(function () {

                Route::any('payment-success/{method}', 'paymentSuccess')->name('payment-success');

                Route::any('payment-cancel/{method}', 'paymentCancel')->name('payment-cancel');

                Route::any('payment-check/{method}', 'paymentCheck')->name('payment-check');

                Route::any('payment-callback/{method}', 'paymentCallback')->name('payment-callback');

                Route::get('payment-view/{method}', 'paymentView')->name('payment-view');

                Route::get('crypto-payment-view/{trx}', 'cryptoView')->name('crypto-payment-view')->middleware('signed');

                Route::post('crypto-payment-status/{id}', 'cryptoPaymentStatus')->name('crypto-payment-status');
            });

            Route::controller(CommonController::class)->group(function () {
                Route::get('notification', 'notification')->name('notification');
                Route::get('mark-as-all-read', 'markAsAllRead')->name('mark-as-all-read');
                Route::get('notifications-read/{id}', 'notificationMarkAsRead')->name('notification-read');
            });

            Route::controller(StageController::class)->group(function () {
                Route::get('stages', 'index')->name('stage.index');
                Route::get('stage/buy/{id}', 'buyStage')->name('stage.buy');
                Route::get('stage/calculation', 'calculation')->name('stage.buy.calculation');
                Route::post('stage/buy/with-balance/{stage}', 'withBalance')->name('stage.buy.balance');
                Route::post('stage/buy/with-payment/{stage}/{currency}', 'withPayment')->name('stage.buy.payment');
            });
        });
    });


    Route::controller(HomeController::class)->group(function () {
        Route::get('/', 'home')->name('home');

        Route::post('subscribe', 'subscribe')->name('subscribe');

        Route::get('blog/{tag?}', 'blog')->name('blog');
        Route::get('blog/details/{slug}', 'blogDetails')->name('blog.details');
        Route::get('blog/category/{slug}', 'blogCategory')->name('blog.category');
        Route::get('stage/calculate', 'stageCalculate')->name('stage.calculate');
        Route::get('whitepaper/download', 'whitepaperDownload')->name('whitepaper.download');
        Route::post('contact', 'contact')->name('contact');
    });

    Route::controller(CommonController::class)->group(function () {
        Route::get('language-switch/{code}', 'languageSwitch')->name('language-switch');
        Route::get('cookie-policy', 'cookiePolicy')->name('cookie-policy');
    });
});

Route::middleware('maintanance_mode_off')
    ->controller(CommonController::class)
    ->group(function () {
        Route::get('maintanance-mode', 'maintananceMode')->name('maintanance-mode');
    });

Route::get('panel', function () {
    return to_route('panel.login');
});

Route::controller(CronController::class)->group(function () {
    Route::get('cron', 'execute')->name('cron');
});

Route::controller(HomeController::class)->group(function () {
    Route::get('{page}', 'page')->name('page');
});
